/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;

public final class SynchronizedTransactions
extends Transactions {
    private static final ThreadLocal<Transactions.Transaction> ACTIVE_TRANSACTION = new ThreadLocal();
    private final Cache localCache;
    private final AtomicReference<TransactionListener> transactionListener = new AtomicReference();
    private final TransactionTable transactionTable;
    protected static final Set<String> ACTIVE_TRACE_SYNCHRONIZATIONS = new HashSet<String>();

    public SynchronizedTransactions(TransactionManager txnMgr, Cache localCache) {
        super(txnMgr);
        assert (this.txnMgr != null);
        this.localCache = localCache;
        assert (this.localCache != null);
        this.transactionTable = localCache.getAdvancedCache().getComponentRegistry().getTransactionTable();
        assert (this.transactionTable != null);
    }

    @Override
    public Transactions.Transaction currentTransaction() {
        return ACTIVE_TRANSACTION.get();
    }

    @Override
    public Transactions.Transaction begin() throws NotSupportedException, SystemException {
        Transactions.Transaction result = ACTIVE_TRANSACTION.get();
        if (result != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Found active ModeShape transaction '{0}' ", new Object[]{result});
            }
            return result instanceof Transactions.NestableThreadLocalTransaction ? ((Transactions.NestableThreadLocalTransaction)result).begin() : result;
        }
        Transaction txn = this.txnMgr.getTransaction();
        if (txn == null) {
            this.txnMgr.begin();
            result = new Transactions.NestableThreadLocalTransaction(this, this.txnMgr, ACTIVE_TRANSACTION).begin();
        } else {
            GlobalTransaction globalTransaction;
            if (this.transactionListener.get() == null && this.transactionListener.compareAndSet(null, new TransactionListener())) {
                this.localCache.addListener((Object)this.transactionListener.get());
            }
            if ((globalTransaction = this.transactionTable.getGlobalTransaction(txn)) == null) {
                this.logger.debug("Active transaction detected, but the Infinispan cache isn't aware of it. Suspending it for the duration of the ModeShape transaction...", new Object[0]);
                final Transaction suspended = this.txnMgr.suspend();
                assert (suspended != null);
                this.txnMgr.begin();
                result = new Transactions.NestableThreadLocalTransaction(this, this.txnMgr, ACTIVE_TRANSACTION).begin();
                result.uponCompletion(new Transactions.TransactionFunction(){

                    @Override
                    public void execute() {
                        try {
                            SynchronizedTransactions.this.txnMgr.resume(suspended);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                result = new SynchronizedTransaction(this.txnMgr, globalTransaction);
            }
        }
        ACTIVE_TRANSACTION.set(result);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Created & stored new ModeShape synchronized transaction '{0}' ", new Object[]{result});
            if (txn == null) {
                txn = this.txnMgr.getTransaction();
            }
            assert (txn != null);
            String id = txn.toString();
            if (!ACTIVE_TRACE_SYNCHRONIZATIONS.contains(id)) {
                if (result instanceof SynchronizedTransaction) {
                    this.logger.trace("Found user transaction {0}", new Object[]{txn});
                } else {
                    this.logger.trace("Begin transaction {0}", new Object[]{id});
                }
                try {
                    txn.registerSynchronization((Synchronization)new TransactionTracer(id));
                }
                catch (RollbackException e) {
                    return new RollbackOnlyTransaction();
                }
            } else {
                this.logger.trace("Tracer already registered for transaction {0}", new Object[]{id});
            }
        }
        return result;
    }

    @Override
    public void updateCache(final WorkspaceCache workspace, final ChangeSet changes, Transactions.Transaction transaction) {
        if (changes != null && !changes.isEmpty()) {
            if (transaction instanceof SynchronizedTransaction) {
                transaction.uponCommit(new Transactions.TransactionFunction(){

                    @Override
                    public void execute() {
                        workspace.changed(changes);
                    }
                });
                if (workspace instanceof TransactionalWorkspaceCache) {
                    ((TransactionalWorkspaceCache)workspace).changedWithinTransaction(changes);
                }
            } else if (!(transaction instanceof RollbackOnlyTransaction)) {
                workspace.changed(changes);
            }
        }
    }

    protected final class TransactionTracer
    implements Synchronization {
        private String txnId;

        protected TransactionTracer(String id) {
            this.txnId = id;
            ACTIVE_TRACE_SYNCHRONIZATIONS.add(id);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ACTIVE_TRACE_SYNCHRONIZATIONS.remove(this.txnId);
            switch (status) {
                case 3: {
                    SynchronizedTransactions.this.logger.trace("Commit transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
                case 4: {
                    SynchronizedTransactions.this.logger.trace("Roll back transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
            }
        }
    }

    protected class RollbackOnlyTransaction
    implements Transactions.Transaction {
        @Override
        public int status() {
            return 5;
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void uponCompletion(Transactions.TransactionFunction function) {
        }

        @Override
        public void uponCommit(Transactions.TransactionFunction function) {
        }
    }

    @Listener
    protected final class TransactionListener {
        protected TransactionListener() {
        }

        @TransactionCompleted
        public void transactionCompleted(TransactionCompletedEvent event) {
            if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("Received transaction completed event: '{0}'", new Object[]{event});
            }
            if (!event.isOriginLocal()) {
                if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                    SynchronizedTransactions.this.logger.trace("Ignoring event '{0}' because it did not originate on this cluster node", new Object[]{event});
                }
                return;
            }
            GlobalTransaction eventIspnTransaction = event.getGlobalTransaction();
            if (eventIspnTransaction == null) {
                if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                    SynchronizedTransactions.this.logger.trace("Ignoring event '{0}' because there is no mapped active user transaction", new Object[]{event});
                }
                return;
            }
            Transactions.Transaction activeTransaction = SynchronizedTransactions.this.currentTransaction();
            if (activeTransaction instanceof SynchronizedTransaction && ((SynchronizedTransaction)activeTransaction).ispnTransaction().equals((Object)eventIspnTransaction)) {
                SynchronizedTransaction synchronizedTransaction = (SynchronizedTransaction)activeTransaction;
                ACTIVE_TRANSACTION.remove();
                if (event.isTransactionSuccessful()) {
                    synchronizedTransaction.executeFunctionsUponCommit();
                }
                synchronizedTransaction.executeFunctionsUponCompletion();
            } else if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("Ignoring event '{0}' because the transaction id does not match that of the active thread transaction '{1}'", new Object[]{event, activeTransaction});
            }
        }
    }

    protected final class SynchronizedTransaction
    extends Transactions.BaseTransaction {
        private final GlobalTransaction ispnTransaction;

        protected SynchronizedTransaction(TransactionManager txnMgr, GlobalTransaction ispnTransaction) {
            super(SynchronizedTransactions.this, txnMgr);
            this.ispnTransaction = ispnTransaction;
        }

        @Override
        public void commit() {
            if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("'{0}' ignoring commit call coming from ModeShape. Waiting to be notified by Infinispan'", new Object[]{this});
            }
        }

        @Override
        public void rollback() {
            if (SynchronizedTransactions.this.logger.isTraceEnabled()) {
                SynchronizedTransactions.this.logger.trace("'{0}' ignoring rollback call coming from ModeShape. Waiting to be notified by Infinispan'", new Object[]{this});
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SynchronizedTransaction{");
            sb.append("infinispanTransaction=").append(this.ispnTransaction);
            sb.append('}');
            return sb.toString();
        }

        protected GlobalTransaction ispnTransaction() {
            return this.ispnTransaction;
        }
    }
}

