/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import java.io.IOException;
import org.modeshape.common.logging.Logger;

abstract class RetryOperation {
    private static final Logger LOGGER = Logger.getLogger(RetryOperation.class);
    private static final int RETRIES = 3;
    private static final long SLEEP_BETWEEN_RETRIES = 2000L;

    RetryOperation() {
    }

    public boolean doTry() throws IOException {
        boolean sleepInterrupted = false;
        int failures = 0;
        IOException lastException = null;
        while (!sleepInterrupted && failures <= 3) {
            try {
                return this.call();
            }
            catch (IOException ex) {
                lastException = ex;
            }
            catch (Exception ex) {
                lastException = new IOException(ex);
            }
            LOGGER.debug((Throwable)lastException, "Failed to execute cache operation.", new Object[0]);
            if (++failures > 3) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                sleepInterrupted = true;
                LOGGER.debug("Retry interrupted. ", new Object[0]);
            }
        }
        assert (lastException != null);
        throw lastException;
    }

    protected abstract boolean call() throws IOException;
}

