/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.delta;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.HashCode;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.ArrayOperation;
import org.infinispan.schematic.internal.document.MutableArray;
import org.infinispan.schematic.internal.document.MutableDocument;

@SerializeWith(value=Externalizer.class)
public class SetValueOperation
extends ArrayOperation {
    protected final Object value;
    protected final int index;
    protected transient Object oldValue;

    public SetValueOperation(Path parentPath, Object value, int index) {
        super(parentPath, HashCode.compute(parentPath, value, index));
        this.value = value;
        this.index = index;
    }

    @Override
    public SetValueOperation clone() {
        return new SetValueOperation(this.getParentPath(), this.cloneValue(this.value), this.index);
    }

    @Override
    public void rollback(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        if (this.oldValue != null) {
            array.set(this.index, this.oldValue);
        } else {
            array.remove(this.index);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.oldValue = array.setValue(this.index, this.value);
    }

    public String toString() {
        return "Set at '" + this.parentPath + "' the value '" + this.value + "' (at index " + this.index + ")";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SetValueOperation) {
            SetValueOperation other = (SetValueOperation)obj;
            return this.equalsIfNotNull(this.value, other.value) && this.index == other.index && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }

    @SerializeWith(value=Externalizer.class)
    public static final class Externalizer
    extends SchematicExternalizer<SetValueOperation> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, SetValueOperation put) throws IOException {
            output.writeObject(put.parentPath);
            output.writeObject(put.index);
            output.writeObject(put.value);
        }

        public SetValueOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Path path = (Path)input.readObject();
            int index = input.readInt();
            Object value = input.readObject();
            return new SetValueOperation(path, value, index);
        }

        @Override
        public Integer getId() {
            return 1612;
        }

        @Override
        public Set<Class<? extends SetValueOperation>> getTypeClasses() {
            return Collections.singleton(SetValueOperation.class);
        }
    }
}

