/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import com.xebialabs.license.LicenseParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.HexEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtils {
    private static final Logger logger = LoggerFactory.getLogger(LicenseUtils.class);

    private LicenseUtils() {
    }

    public static byte[] readKey(String data) throws IOException {
        HexEncoder hexit = new HexEncoder();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        hexit.decode(data, (OutputStream)bos);
        return bos.toByteArray();
    }

    public static boolean isBase64License(String licenseText) {
        if (licenseText.contains("-") && licenseText.contains(":")) {
            return false;
        }
        if (!licenseText.contains("-") && !licenseText.contains(":")) {
            return true;
        }
        logger.warn("licenseText {} does not contain a - and a :, which is invalid");
        return false;
    }

    public static String decodeBase64License(String data) {
        String decoded;
        String stripped = CharMatcher.WHITESPACE.removeFrom((CharSequence)data);
        try {
            decoded = new String(BaseEncoding.base64().decode((CharSequence)stripped), StandardCharsets.UTF_8).replaceAll("\\r\\n?", "\n");
        }
        catch (IllegalArgumentException iae) {
            Throwable cause = iae.getCause();
            if (cause != null && cause instanceof BaseEncoding.DecodingException) {
                throw new LicenseParseException(data, cause.getMessage());
            }
            throw new LicenseParseException(data, "Parsing license text failed", iae);
        }
        return decoded;
    }

    public static String decodeIfNecessary(String text) {
        if (LicenseUtils.isBase64License(text)) {
            return LicenseUtils.decodeBase64License(text);
        }
        return text;
    }
}

