/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.base.Charsets;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseRepositoryIdException;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.LicenseInstallService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class LicenseRegistrationServlet
extends HttpServlet {
    public static final String PRODUCT_NAME = "productName";
    public static final String PRODUCT_LOGO_URL = "productLogoUrl";
    public static final String REGISTRATION_TEMPLATE_FILENAME = "registration.mustache";
    public static final String REGISTRATION_VIEW_MODEL_KEY = "registration-view-model";
    public static final String FONT_LOCATION_EOT = "fontLocationEot";
    public static final String FONT_LOCATION_TTF = "fontLocationTtf";
    public static final String FAVICON = "favicon";
    public static final String FAVICON_TYPE = "faviconType";
    public static final String ACTIVATION_URL = "faviconType";
    private Logger logger = LoggerFactory.getLogger(LicenseRegistrationServlet.class);
    @Autowired
    private LicenseInstallService licenseInstallService;
    private String productName = "{{Define productName init-param}}";
    private String productLogoUrl = "";
    private String fontLocationEot = "fonts/open-sans/OpenSans-Regular-webfont.eot";
    private String fontLocationTtf = "fonts/open-sans/OpenSans-Regular-webfont.ttf";
    private String favicon = "favicon.png";
    private String faviconType = "image/png";
    private String activationUrl = "";

    public LicenseRegistrationServlet(LicenseInstallService licenseInstallService) {
        this.licenseInstallService = licenseInstallService;
    }

    public LicenseRegistrationServlet() {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
        if (config.getInitParameter(PRODUCT_NAME) != null) {
            this.productName = config.getInitParameter(PRODUCT_NAME);
        }
        if (config.getInitParameter(PRODUCT_LOGO_URL) != null) {
            this.productLogoUrl = config.getInitParameter(PRODUCT_LOGO_URL);
        }
        if (config.getInitParameter(FONT_LOCATION_EOT) != null) {
            this.fontLocationEot = config.getInitParameter(FONT_LOCATION_EOT);
        }
        if (config.getInitParameter(FONT_LOCATION_TTF) != null) {
            this.fontLocationTtf = config.getInitParameter(FONT_LOCATION_TTF);
        }
        if (config.getInitParameter(FAVICON) != null) {
            this.favicon = config.getInitParameter(FAVICON);
        }
        if (config.getInitParameter("faviconType") != null) {
            this.faviconType = config.getInitParameter("faviconType");
        }
        if (config.getInitParameter("faviconType") != null) {
            this.activationUrl = config.getInitParameter("faviconType");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RegistrationViewModel registrationViewModel = (RegistrationViewModel)req.getSession().getAttribute(REGISTRATION_VIEW_MODEL_KEY);
        if (registrationViewModel == null) {
            registrationViewModel = new RegistrationViewModel(req.getContextPath());
        } else {
            req.getSession().removeAttribute(REGISTRATION_VIEW_MODEL_KEY);
        }
        this.pageContent(registrationViewModel);
        this.renderTemplate(resp, registrationViewModel, REGISTRATION_TEMPLATE_FILENAME);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RegistrationViewModel registrationViewModel;
        block7: {
            registrationViewModel = new RegistrationViewModel(req.getContextPath());
            String licenseText = req.getParameter("license");
            if (this.licenseTextIsProvided(licenseText)) {
                registrationViewModel.setLicenseText(licenseText);
                try {
                    License license = this.licenseInstallService.installNewLicense(licenseText);
                    if (license != null) {
                        registrationViewModel.setCanUseProduct();
                        registrationViewModel.setValidMessage(String.format("Your license is valid until %s.", license.getLocalDateValue(LicenseProperty.EXPIRES_AFTER).toString("MMMM d, yyyy")));
                        registrationViewModel.setLicense(license);
                        break block7;
                    }
                    registrationViewModel.setWarningMessage("The license key provided is not valid.");
                }
                catch (LicenseRepositoryIdException e) {
                    registrationViewModel.setWarningMessage("This installation is locked to a previous license. Please renew your license.");
                }
                catch (LicenseViolationException e) {
                    registrationViewModel.setWarningMessage(String.format("There is a problem with the provided license key: %s.", e.getMessage()));
                }
                catch (Exception e) {
                    this.logger.warn("Failed to install license with license text: [{}]", (Object)licenseText, (Object)e);
                    registrationViewModel.setWarningMessage(String.format("An error occurred while installing the license key: %s.", e.getMessage()));
                }
            } else {
                registrationViewModel.setWarningMessage("No license key was provided. Enter a license key in the field above.");
            }
        }
        req.getSession().setAttribute(REGISTRATION_VIEW_MODEL_KEY, (Object)registrationViewModel);
        resp.sendRedirect(req.getRequestURI());
    }

    private void pageContent(RegistrationViewModel registrationViewModel) {
        registrationViewModel.setLicenseRenewalMessage(this.licenseInstallService.getLicenseRenewalMessage());
    }

    private boolean licenseTextIsProvided(String licenseText) {
        return licenseText != null && !"".equals(licenseText);
    }

    private void renderTemplate(HttpServletResponse resp, RegistrationViewModel registrationViewModel, String templateFile) throws IOException {
        InputStream resource = ((Object)((Object)this)).getClass().getResourceAsStream(templateFile);
        InputStreamReader reader = new InputStreamReader(resource);
        Mustache.Compiler compiler = Mustache.compiler().emptyStringIsFalse(true).defaultValue("");
        Template templ = compiler.compile((Reader)reader);
        PrintWriter writer = resp.getWriter();
        resp.setContentType("text/html");
        templ.execute(registrationViewModel.toScope(), (Writer)writer);
    }

    static String encodedEmailFromContact(String contact) {
        Pattern compile = Pattern.compile(".*<.*@.*>");
        String email = compile.matcher(contact).matches() ? contact.substring(contact.indexOf(60) + 1, contact.indexOf(62)) : contact;
        try {
            return URLEncoder.encode(email, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return contact;
        }
    }

    class RegistrationViewModel {
        private final String contextPath;
        private String validMessage = "";
        private String warningMessage = "";
        private String submitLicenseState = "";
        private String useProductState = "disabled";
        private String licenseText = "";
        private License license;
        private String licenseRenewalMessage;

        public RegistrationViewModel(String contextPath) {
            this.contextPath = contextPath.endsWith("/") ? contextPath : contextPath + "/";
        }

        public void setValidMessage(String message) {
            this.warningMessage = "";
            this.validMessage = message;
        }

        public void setWarningMessage(String message) {
            this.warningMessage = message;
            this.validMessage = "";
        }

        public Map<String, Object> toScope() {
            HashMap<String, Object> scope = new HashMap<String, Object>();
            scope.put(LicenseRegistrationServlet.PRODUCT_NAME, LicenseRegistrationServlet.this.productName);
            scope.put(LicenseRegistrationServlet.PRODUCT_LOGO_URL, LicenseRegistrationServlet.this.productLogoUrl);
            scope.put(LicenseRegistrationServlet.FONT_LOCATION_TTF, LicenseRegistrationServlet.this.fontLocationTtf);
            scope.put(LicenseRegistrationServlet.FONT_LOCATION_EOT, LicenseRegistrationServlet.this.fontLocationEot);
            scope.put(LicenseRegistrationServlet.FAVICON, LicenseRegistrationServlet.this.favicon);
            scope.put("faviconType", LicenseRegistrationServlet.this.faviconType);
            scope.put("contextPath", this.contextPath);
            scope.put("activationUrl", LicenseRegistrationServlet.this.activationUrl);
            scope.put("valid", this.validMessage);
            scope.put("warning", this.warningMessage);
            scope.put("submitLicenseState", this.submitLicenseState);
            scope.put("useProductState", this.useProductState);
            scope.put("licenseText", this.licenseText);
            scope.put("licenseRenewalMessage", this.licenseRenewalMessage);
            if (this.license != null) {
                scope.put("product", this.license.getStringValue(LicenseProperty.PRODUCT));
                scope.put("licensedTo", this.license.getStringValue(LicenseProperty.LICENSED_TO));
                String contact = this.license.getStringValue(LicenseProperty.CONTACT);
                scope.put("contact", contact);
                scope.put("repositoryId", this.license.getStringValue(LicenseProperty.REPOSITORY_ID));
                scope.put("expiresAfter", this.license.getStringValue(LicenseProperty.EXPIRES_AFTER));
                scope.put("contactEmail", LicenseRegistrationServlet.encodedEmailFromContact(contact));
            }
            scope.put("copyrightYear", new LocalDate().getYear());
            return scope;
        }

        public void setCanUseProduct() {
            this.submitLicenseState = "disabled";
            this.useProductState = "";
        }

        public void setLicenseText(String licenseText) {
            this.licenseText = licenseText;
        }

        public void setLicense(License license) {
            this.license = license;
        }

        public void setLicenseRenewalMessage(String licenseRenewalMessage) {
            this.licenseRenewalMessage = licenseRenewalMessage;
        }
    }
}

