/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import org.apache.http.impl.auth.KerberosScheme;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WsmanKerberosScheme
extends KerberosScheme {
    private final String spnServiceClass;
    private final String spnAddress;
    private final int spnPort;
    private static final Logger logger = LoggerFactory.getLogger(WsmanKerberosScheme.class);

    public WsmanKerberosScheme(boolean stripPort, String spnServiceClass, String spnAddress, int spnPort) {
        super(stripPort);
        this.spnServiceClass = spnServiceClass;
        this.spnAddress = spnAddress;
        this.spnPort = spnPort;
    }

    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer) throws GSSException {
        byte[] token = input;
        if (token == null) {
            token = new byte[]{};
        }
        if (authServer.equals("localhost")) {
            authServer = authServer.indexOf(58) > 0 ? this.spnAddress + ":" + this.spnPort : this.spnAddress;
        }
        String spn = this.spnServiceClass + "@" + authServer;
        logger.debug("Requesting Kerberos ticket for SPN {}", (Object)spn);
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName(spn, GSSName.NT_HOSTBASED_SERVICE);
        GSSName canonicalizedName = serverName.canonicalize(oid);
        logger.debug("Creating Kerberos GSS context for canonicalized SPN {}", (Object)canonicalizedName);
        GSSContext gssContext = manager.createContext(canonicalizedName, oid, null, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return gssContext.initSecContext(token, 0, token.length);
    }
}

