# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

prefixParam = get_prefix_param(query_parameters)
prefixArray = get_prefix_array(query_parameters)

events = test_runs.getEventsForTestRun(test_run, {'@tags': tags})

rotation = -45

passed = {}
failed = {}

for ev in events:
    if is_functional_result(ev) and prefix_within_hierarchy(ev, prefixArray):
        x = next_node_in_hierarchy(ev, prefixArray)

        if x is None:
            continue

        result = ev.get('@result')

        if result == 'PASSED':
            passed[x] = passed.get(x, 0) + 1
        else:
            failed[x] = failed.get(x, 0) + 1

categories = sorted(set(failed.keys() + passed.keys()))

def make_column_values(counts):
    return map(lambda t: counts.get(t, 0) > 1 and { 'y': counts[t], 'params': { 'prefix': ';'.join(prefixArray + [t]) } } or counts.get(t, 0), categories)

# Rework our data for representation (to highcharts format)
passed = make_column_values(passed)
failed = make_column_values(failed)

level = len(prefixArray)
if level == 0:
    title = 'Passed versus failed tests from latest test run in time window'
else:
    title = 'Passed versus failed tests from latest test run in time window at level %s' % level

result_holder.result = {
        'chart': {
            'type': 'column'
        },
        'title': title,
        'description': 'This report presents the tests that passed and failed during the last execution of the test specification.',
        'xAxis': {
            'categories': categories,
            'labels': {
                'rotation': rotation,
            }
        },
        'yAxis': {
            'min': 0,
            'title': {
                'text': 'Number of tests',
                'style': {
                    'color': '#666',
                    'font-weight': 'normal'
                }
            },
            'minTickInterval': 1
        },
        'legend': {
            'borderColor': None,
            'symbolHeight': 16,
            'symbolWidth': 16
        },
        'plotOptions': {
            'column': {
                'animation': False,
                'cursor': 'pointer',
                'borderRadius': 2,
                'groupPadding': 0.1,
                'pointPadding': 0.01
            },
            'series':  {
               'point': {
                   'events': {
                       'click': 'url'
                   }
               }
           } or None
        },
        'series': [{
            'name': 'Passed',
            'data': passed
        }, {
            'name': 'Failed',
            'data': failed
        }]
    }

