<#--
 # NOTE: Please do not edit this file directly
 # Create your custom reports in the 'ext' folder
 #-->

<#macro RESULTTYPE result title>
<h3>${title}</h3>
<table class="table">
<thead>
<tr>
    <th>Test</th><th>Full name</th>
</tr>
</thead>
<tbody>
<#assign prefix = query_parameters['prefix']!"">
<#assign date = query_parameters['date']!"">
<#assign range = query_parameters['range']!"">
<#assign depth = prefix?split(";")?size>
<#list events as event>
  <#assign name = event.get('@hierarchy')!?join(";") >
  <#if prefix == "">
    <#assign nameMatches = true>
  <#else>
    <#assign nameMatches = (name == prefix || name?starts_with(prefix + ";"))>
  </#if>
  <#if event.type == 'functionalResult' && event.getResult() == result && nameMatches>
    <tr>
      <#assign url = "#/testspecifications/" + event.testSpecificationName + "/report/xlt.TestCaseOverview?testcase=" + name + "&date=" + date + "&range=" + range>
      <td data-role="testCaseDetails"><a href="${url}">${event.get('@hierarchy')!?last}</a></td>
      <td>${name}</td>
    </tr>
    <tr class="secondary">
      <td colspan="4">
        <#if depth &gt; 3>
          <#assign correspondingOlderEvents = test_runs.getCorrespondingEventsFromOlderRuns(test_run, event, this.getProperty('maxRunsInHistory')?int, 'type', 'name')>
          <#assign thisResult = event.getResult()!"">
          <#assign prevResult = thisResult>
          <#assign nChanges = 0>
          <#assign total = 1>
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = olderEvent.getResult()!"">
            <#if oldResult != prevResult>
              <#assign prevResult = oldResult>
              <#assign nChanges = nChanges + 1>
            </#if>
            <#assign total = total + 1>
          </#list>

          <#assign flaky = ((nChanges / total) * 100)?floor >
          <#assign report_id = 'xlt.BarChart' >
          <br/>
          <table>
            <tr>
              <td><div title="Flakiness is the number of different test results over time divided by the number of test results">${flaky}% flaky</div></td>
                <#list correspondingOlderEvents as olderEvent>
                  <#assign oldResult = olderEvent.getResult()!"">
                  <#assign runId = olderEvent.get('@runId') >
                  <#assign team = olderEvent.get('team')!"" >
                  <#assign name = olderEvent.get('name') >
                  <#assign level0 = "">
                  <#assign level1 = "">
                  <#assign level2 = "">
                  <#assign level3 = "">
                  <#list name?split(";") as x>
                    <#if x_index == 0>
                      <#assign level0 = x>
                    </#if>
                    <#if x_index == 1>
                      <#assign level1 = x>
                    </#if>
                    <#if x_index == 2>
                      <#assign level2 = x>
                    </#if>
                    <#if x_index == 3>
                      <#assign level3 = x>
                    </#if>
                  </#list>
                  <#assign runDay = this.thisDay(olderEvent.get('@createdAt')) >
                  <#if oldResult == "PASSED">
                    <td bgcolor="#9ada7f">
                  <#else>
                    <td bgcolor="#fd8d10">
                  </#if>
                  <a href="#/reports/${runId}/${report_id}?prefix=${level0};">${runDay}</a>
                </td>
              </#list>
            </tr>
          </table>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
</tbody>
</table>
</#macro>

<#assign queryParams = {"tags": tags }>
<#assign events = test_runs.getEventsForTestRun(test_run, queryParams) >
<div data-title="Detail report">
<p>This report shows detailed information about each test in the latest execution of the test specification.</p>
<@RESULTTYPE result="FAILED" title="Failed"/>
<@RESULTTYPE result="PASSED" title="Passed"/>
</div>

