from parser.xunit import validate_files, get_root_node, parse_last_modified, parse_junit_test_results
from datetime import datetime
from com.xebialabs.xlt.plugin.api.resultparser import MalformedInputException

testng_time_format = '%d %b %Y %H:%M:%S %Z'

def testng_last_modified(file):
    root = get_root_node(file)
    timestamp = root.attrib["timestamp"]
    return int(((datetime.strptime(timestamp, testng_time_format) - datetime(1970,1,1)).total_seconds() * 1000))


def testng_result(testCase):
    failure = testCase.find("error")
    if failure is not None:
        return "FAILED"
    else:
        return "PASSED"


def testng_failure_reason(testCase):
    if testng_result(testCase) == "FAILED":
        failure = testCase.find("error")
        if failure is not None:
            return failure.attrib.get("message", "No failure reason").strip()
        else:
            raise MalformedInputException("Expected to have found a failure reason!")
    else:
        return None


def testng_validate_timestamp(root):
    timestamp = root.attrib["timestamp"]
    try:
        datetime.strptime(timestamp, testng_time_format)
        return True
    except ValueError:
        return False

validate_files(files, validate_timestamp=testng_validate_timestamp)

last_modified = parse_last_modified(files, extract_last_modified=testng_last_modified)

if not test_run_historian.isKnownKey(str(last_modified)):
    events = parse_junit_test_results(files, last_modified,
                                      extract_result=testng_result,
                                      extract_failure_reason=testng_failure_reason)
else:
    events = []

# Result holder should contain a list of test runs. A test run is a list of events

result_holder.result = [events] if events else []
