/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public abstract class StepJsonConverter {
    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();

    public String toJson(StepState step) {
        JsonWriter writer = new JsonWriter();
        this.writeJson(step, writer);
        return writer.toString();
    }

    public JsonWriter writeJson(StepState step, JsonWriter writer) {
        writer.object();
        writer.key("state").value(step.getState());
        writer.key("failures").value(step.getFailureCount());
        writer.key("description").value(step.getDescription());
        if (step.getStartDate() != null) {
            writer.key("startDate").value(this.timeAdapter.marshal(step.getStartDate()));
        }
        if (step.getCompletionDate() != null) {
            writer.key("completionDate").value(this.timeAdapter.marshal(step.getCompletionDate()));
        }
        if (step.getLog() != null) {
            writer.key("log").value(step.getLog());
        }
        writer.endObject();
        return writer;
    }

    public StepState toStep(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            StepExecutionState state = StepExecutionState.valueOf((String)json.getString("state"));
            int failureCount = json.getInt("failures");
            String description = json.getString("description");
            DateTime startDate = null;
            if (json.has("startDate")) {
                startDate = this.timeAdapter.unmarshal(json.getString("startDate"));
            }
            DateTime completionDate = null;
            if (json.has("completionDate")) {
                completionDate = this.timeAdapter.unmarshal(json.getString("completionDate"));
            }
            String log = null;
            if (json.has("log")) {
                log = json.getString("log");
            }
            return this.createStepState(state, failureCount, description, startDate, completionDate, log);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    protected abstract StepState createStepState(StepExecutionState var1, int var2, String var3, DateTime var4, DateTime var5, String var6);
}

