/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlt.plugin.api.testrun;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xlt.plugin.api.testrun.InvalidEventException;
import com.xebialabs.xlt.plugin.api.testrun.InvalidRunException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class EventValidator {
    private static final Set<String> VALID_EVENT_TYPES = ImmutableSet.of((Object)"importFinished", (Object)"importStarted", (Object)"performanceResult", (Object)"functionalResult");
    private static final Set<String> OUR_KEYS = ImmutableSet.of((Object)"_id", (Object)"@runId", (Object)"@createdAt", (Object)"@type", (Object)"@testSpecification", (Object)"@testedAt", (Object[])new String[]{"@tags", "@runKey", "executionStarted", "executionFinished", "importStarted", "importFinished", "functionalResult", "performanceResult", "OTHER", "childRunId", "childFinished", "childStarted", "@duration", "@result", "@firstError", "@hierarchy", "numberOfRequests.total", "numberOfRequests.ok", "numberOfRequests.ko", "@size"});

    private EventValidator() {
    }

    public static void validateRun(List<Event> events) {
        if (events.isEmpty()) {
            return;
        }
        String testSpec = "";
        String runId = null;
        boolean firstEvent = true;
        int importStarted = 0;
        int importFinished = 0;
        int functionalResult = 0;
        int performanceResult = 0;
        HashSet<String> hierarchies = new HashSet<String>();
        block12: for (Event e : events) {
            EventValidator.validateEvent(e);
            if (firstEvent) {
                testSpec = e.getTestSpecificationName();
                runId = e.getTestRunId();
                firstEvent = false;
            } else {
                if (!e.getTestSpecificationName().equals(testSpec)) {
                    throw new InvalidEventException(e, String.format("event['%s'] was not equal for all events", "@testSpecification"));
                }
                if (!e.getTestRunId().equals(runId)) {
                    throw new InvalidEventException(e, String.format("event['%s'] was not equal for all events", "@runId"));
                }
            }
            switch (e.getType()) {
                case "importStarted": {
                    ++importStarted;
                    continue block12;
                }
                case "importFinished": {
                    ++importFinished;
                    EventValidator.checkImportFinished(e);
                    EventValidator.checkValue(e, "@size", events.size());
                    continue block12;
                }
                case "functionalResult": {
                    ++functionalResult;
                    EventValidator.checkFunctionalResult(e);
                    EventValidator.validateEventHierarchy(e, hierarchies, events);
                    continue block12;
                }
                case "performanceResult": {
                    ++performanceResult;
                    EventValidator.checkPerformanceResult(e);
                    continue block12;
                }
            }
            throw new InvalidEventException(e, String.format("event['%s'] should be one of %s (got '%s')", "@type", VALID_EVENT_TYPES, e.getType()));
        }
        if (importStarted != 1) {
            throw new InvalidRunException(events, String.format("Event set contained %s import-started events, while exactly 1 is allowed", importStarted));
        }
        if (importFinished != 1) {
            throw new InvalidRunException(events, String.format("Event set contained %s import-finished events, while exactly 1 is allowed", importFinished));
        }
        if (functionalResult == 0 && performanceResult == 0) {
            throw new InvalidRunException(events, "Event set did not contain a functional or performance result");
        }
        if (functionalResult != 0 && performanceResult != 0) {
            throw new InvalidRunException(events, "Event set contained both functional and performance results");
        }
    }

    public static Event validateEvent(Event e) {
        EventValidator.checkProperties(e);
        EventValidator.checkPresent(e, "@type");
        EventValidator.checkPresent(e, "@testSpecification");
        EventValidator.checkPresent(e, "@runId");
        EventValidator.checkPresent(e, "@createdAt");
        EventValidator.checkValidType(e, "@testSpecification", String.class);
        EventValidator.checkValidType(e, "@runId", String.class);
        EventValidator.checkValidType(e, "@createdAt", Long.class);
        if (e.getCreatedAt() > System.currentTimeMillis()) {
            throw new InvalidEventException(e, String.format("event['%s'] is in the future", "@createdAt"));
        }
        return e;
    }

    private static void validateEventHierarchy(Event e, Set<String> hierarchies, List<Event> events) {
        String hierarchy = EventValidator.makeNormalizedHierarchy((List)e.get("@hierarchy"));
        if (hierarchies.contains(hierarchy)) {
            throw new InvalidRunException(events, "Duplicate hierarchy encountered: " + e.getHierarchy());
        }
        hierarchies.add(hierarchy);
    }

    private static String makeNormalizedHierarchy(List<String> hierarchy) {
        return Joiner.on((String)">|<").join(hierarchy);
    }

    private static void checkImportFinished(Event e) {
        EventValidator.checkPresent(e, "@duration");
        EventValidator.checkPresent(e, "@size");
    }

    private static void checkProperties(Event e) {
        for (String key : e.getProperties().keySet()) {
            if (!key.startsWith("@") || OUR_KEYS.contains(key)) continue;
            throw new InvalidEventException(e, String.format("event contained a custom property starting with @ (%s). This is not valid.", key));
        }
    }

    private static void checkFunctionalResult(Event e) {
        EventValidator.checkHasText(e, "@result");
        EventValidator.checkNotNegative(e, "@duration");
        EventValidator.checkPresent(e, "@hierarchy");
        EventValidator.checkValidType(e, "@hierarchy", Collection.class);
        EventValidator.checkListHasContent(e, "@hierarchy");
    }

    private static void checkPerformanceResult(Event e) {
        EventValidator.checkPresent(e, "numberOfRequests.ko");
        EventValidator.checkPresent(e, "numberOfRequests.ok");
        EventValidator.checkPresent(e, "meanResponseTime.total");
        EventValidator.checkValidType(e, "numberOfRequests.ko", Number.class);
        EventValidator.checkNotNegative(e, "numberOfRequests.ko");
        EventValidator.checkValidType(e, "numberOfRequests.ok", Number.class);
        EventValidator.checkNotNegative(e, "numberOfRequests.ok");
        EventValidator.checkValidType(e, "meanResponseTime.total", Number.class);
        EventValidator.checkNotNegative(e, "meanResponseTime.total");
    }

    private static void checkLength(Event e, String property, int maxLength) {
        if (e.getProperties().get(property) == null) {
            return;
        }
        if (e.getProperties().get(property).toString().length() > maxLength) {
            throw new InvalidEventException(e, String.format("event['%s'] is longer than %s characters", property, maxLength));
        }
    }

    private static void checkHasText(Event e, String property) {
        EventValidator.checkPresent(e, property);
        EventValidator.checkValidType(e, property, String.class);
        EventValidator.checkStringContent(e, property);
    }

    private static void checkListHasContent(Event event, String property) {
        List l = (List)event.get(property);
        if (l == null) {
            return;
        }
        if (l.isEmpty()) {
            throw new InvalidEventException(event, String.format("event['%s'] list has no content", property));
        }
    }

    private static void checkStringContent(Event e, String property) {
        if (e.getProperties().get(property).toString().trim().isEmpty()) {
            throw new InvalidEventException(e, String.format("event['%s'] has no text", property));
        }
    }

    private static void checkPresent(Event e, String property) {
        Preconditions.checkNotNull((Object)property);
        Object value = e.getProperties().get(property);
        if (value != null) {
            return;
        }
        throw new InvalidEventException(e, String.format("event['%s'] is not present", property));
    }

    private static void checkValidType(Event e, String property, Class clazz) {
        Object value = e.getProperties().get(property);
        if (value == null) {
            return;
        }
        if (clazz.isInstance(value)) {
            return;
        }
        throw new InvalidEventException(e, String.format("event['%s'] should be of type %s", property, clazz));
    }

    private static void checkNotNegative(Event e, String property) {
        Number integer = (Number)e.getProperties().get(property);
        if (integer == null) {
            return;
        }
        if (integer.longValue() < 0L) {
            throw new InvalidEventException(e, String.format("event['%s'] was negative", property));
        }
    }

    private static void checkValue(Event e, String property, Object value) {
        if (e.get(property).equals(value)) {
            return;
        }
        throw new InvalidEventException(e, String.format("event['%s'] should be %s", property, value));
    }
}

