/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.CifsFile;
import com.xebialabs.overthere.cifs.PathEncoder;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CifsConnection
extends BaseOverthereConnection {
    protected CifsConnectionType cifsConnectionType;
    protected String unmappedAddress;
    protected int unmappedPort;
    protected String address;
    protected int cifsPort;
    protected int port;
    protected String username;
    protected String password;
    protected PathEncoder encoder;
    protected NtlmPasswordAuthentication authentication;
    private static Logger logger = LoggerFactory.getLogger(CifsConnection.class);

    public CifsConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper, boolean canStartProcess) {
        super(protocol, options, mapper, canStartProcess);
        this.cifsConnectionType = options.getEnum("connectionType", CifsConnectionType.class);
        this.unmappedAddress = (String)options.get("address");
        this.unmappedPort = options.get("port", this.getDefaultPort(options));
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(this.unmappedAddress, this.unmappedPort));
        this.address = addressPort.getHostName();
        this.port = addressPort.getPort();
        this.username = (String)options.get("username");
        this.password = (String)options.get("password");
        int unmappedCifsPort = options.getInteger("cifsPort", 445);
        InetSocketAddress addressCifsPort = mapper.map(InetSocketAddress.createUnresolved(this.unmappedAddress, unmappedCifsPort));
        this.cifsPort = addressCifsPort.getPort();
        this.encoder = new PathEncoder(null, null, this.address, this.cifsPort, options.get("pathShareMappings", CifsConnectionBuilder.PATH_SHARE_MAPPINGS_DEFAULT));
        this.authentication = new NtlmPasswordAuthentication(null, this.username, this.password);
    }

    private int getDefaultPort(ConnectionOptions options) {
        switch (this.cifsConnectionType) {
            case TELNET: {
                return 23;
            }
            case WINRM_INTERNAL: 
            case WINRM_NATIVE: {
                if (!options.getBoolean("winrmEnableHttps", false)) {
                    return 5985;
                }
                return 5986;
            }
        }
        throw new IllegalArgumentException("Unknown CIFS connection type " + (Object)((Object)this.cifsConnectionType));
    }

    protected abstract void connect();

    @Override
    public void doClose() {
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        try {
            SmbFile smbFile = new SmbFile(this.encodeAsSmbUrl(hostPath), this.authentication);
            return new CifsFile(this, smbFile);
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        StringBuilder childPath = new StringBuilder();
        childPath.append(parent.getPath());
        if (!parent.getPath().endsWith(this.getHostOperatingSystem().getFileSeparator())) {
            childPath.append(this.getHostOperatingSystem().getFileSeparator());
        }
        childPath.append(child.replace('\\', '/'));
        return this.getFile(childPath.toString());
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return this.getFile(parent, name);
    }

    private String encodeAsSmbUrl(String hostPath) {
        try {
            String smbUrl = this.encoder.toSmbUrl(hostPath);
            logger.trace("Encoded Windows host path [{}] to SMB URL [{}]", (Object)hostPath, (Object)this.maskSmbUrl(smbUrl));
            return smbUrl;
        }
        catch (IllegalArgumentException exception) {
            throw new RuntimeIOException(exception);
        }
    }

    private String maskSmbUrl(String smbUrl) {
        return smbUrl.replace(this.password, "********");
    }

    @Override
    public String toString() {
        return "cifs:" + this.cifsConnectionType.toString().toLowerCase() + "://" + this.username + "@" + this.address + ":" + this.cifsPort + ":" + this.port;
    }
}

