/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProductException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicensePropertyMap;
import com.xebialabs.license.LicenseVersion3;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.MissingLicensePropertyException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public abstract class License {
    public static final String PRODUCT_XL_DEPLOY = "XL Deploy";
    public static final String PRODUCT_OLD_DEPLOYIT = "Deployit";
    public static final String PRODUCT_XL_RELEASE = "XL Release";
    public static final String PRODUCT_XL_TESTVIEW = "XL TestView";
    public static final Set<String> PRODUCTS = Sets.newHashSet((Object[])new String[]{"XL Deploy", "XL Release", "Deployit", "XL TestView"});
    public static final int MAX_TRIAL_LICENSE_VALIDITY = 90;
    private LicensePropertyMap values;

    protected License(LicensePropertyMap values) throws LicenseViolationException {
        this.values = values;
        this.validateLicenseFormat();
    }

    public abstract List<LicenseProperty> getLicenseProperties();

    public abstract List<LicenseProperty> getRequiredProperties();

    public abstract int getLicenseVersion();

    protected void validateProperties() throws MissingLicensePropertyException {
        this.validateRequired();
    }

    private void validateRequired() throws MissingLicensePropertyException {
        for (LicenseProperty licenseProperty : this.getRequiredProperties()) {
            if (this.hasLicenseProperty(licenseProperty)) continue;
            throw new MissingLicensePropertyException(this.emptyErrorMessage(licenseProperty));
        }
    }

    private void validateProduct() throws LicenseProductException {
        String product = (String)this.values.get(LicenseProperty.PRODUCT);
        if (!PRODUCTS.contains(product)) {
            throw new LicenseProductException(String.format("product should be one of: %s got '%s'", PRODUCTS, product));
        }
    }

    public void validateLicenseFormat() throws LicenseViolationException {
        this.validateProperties();
        this.validateProduct();
        this.validateTrialDate();
    }

    private void validateTrialDate() {
        if (this.isAtLeastVersion(3) && this.values.getAsString(LicenseProperty.EDITION).equals(LicenseVersion3.Edition.Trial.name())) {
            LocalDate expireDate = (LocalDate)this.values.get(LicenseProperty.EXPIRES_AFTER);
            if (expireDate == null) {
                throw new LicensePeriodExpiredException("Trial licenses require an expire date");
            }
            LocalDate maxExpireDate = LocalDate.now().plusDays(90);
            if (expireDate.isAfter((ReadablePartial)maxExpireDate)) {
                throw new LicensePeriodExpiredException(String.format("Trial licenses cannot be valid for more than %s days. This license is valid until %s", 90, expireDate));
            }
        }
    }

    public boolean isDateExpired() {
        return this.isDateExpired(LocalDate.now());
    }

    public boolean isDateExpired(LocalDate now) {
        LocalDate localDateValue = this.getLocalDateValue(LicenseProperty.EXPIRES_AFTER);
        return localDateValue != null && now.isAfter((ReadablePartial)localDateValue);
    }

    public String getStringValue(LicenseProperty key) {
        return this.values.getAsString(key);
    }

    public boolean isDummyLicense() {
        return false;
    }

    public LocalDate getLocalDateValue(LicenseProperty key) {
        return (LocalDate)this.values.get(key);
    }

    public Map<String, Integer> getMapValue(LicenseProperty key) {
        return (Map)this.values.get(key);
    }

    public List<String> getListValue(LicenseProperty property) {
        return Lists.newArrayList((Iterable)((List)this.values.get(property)));
    }

    public boolean hasLicenseProperty(LicenseProperty key) {
        return this.values.containsKey(key);
    }

    private String emptyErrorMessage(LicenseProperty property) {
        return String.format("'%s' cannot be empty", property.getName().toLowerCase());
    }

    private String formatAll(String format) {
        StringBuilder collector = new StringBuilder();
        for (LicenseProperty licenseProperty : this.getLicenseProperties()) {
            this.values.format(collector, format, licenseProperty);
        }
        return collector.toString();
    }

    public String toLicenseContent() {
        return this.formatAll("%s: %s\n");
    }

    public String toString() {
        return this.formatAll("%-" + String.valueOf(LicenseProperty.getLongerNameLength()) + "s: %s\n");
    }

    public boolean isAtLeastVersion(int minimumLicenseVersion) {
        return this.getLicenseVersion() >= minimumLicenseVersion;
    }
}

