/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.google.common.io.Files;
import com.xebialabs.license.AmountOfCisExceededException;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseEditionException;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseReader;
import com.xebialabs.license.LicenseRepositoryIdException;
import com.xebialabs.license.LicenseUtils;
import com.xebialabs.license.LicenseVersionException;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.LicenseInstallService;
import com.xebialabs.license.service.LicenseInstallationFailedException;
import com.xebialabs.license.service.LicenseService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseInstallServiceImpl
implements LicenseInstallService {
    private final File licenseFile;
    private final LicenseService licenseService;
    private static final Logger logger = LoggerFactory.getLogger(LicenseInstallServiceImpl.class);

    public LicenseInstallServiceImpl(String licensePath, LicenseService licenseService) {
        this.licenseFile = new File(licensePath);
        this.licenseService = licenseService;
    }

    boolean canInstallNewLicense() {
        if (!this.licenseFile.exists()) {
            return this.licenseFile.getParentFile().canWrite();
        }
        return this.licenseFile.canWrite();
    }

    @Override
    public License installNewLicense(String licenseText) throws LicenseInstallationFailedException {
        if (!this.canInstallNewLicense()) {
            throw new LicenseInstallationFailedException("Could not install license because the license file could not be written to the file system.");
        }
        try {
            License tmpLicense = this.readLicense(licenseText);
            this.licenseService.validate(tmpLicense);
            String plainText = LicenseUtils.decodeIfNecessary(licenseText);
            Files.write((CharSequence)plainText, (File)this.licenseFile, (Charset)StandardCharsets.UTF_8);
            this.licenseService.reload();
            return tmpLicense;
        }
        catch (LicenseRepositoryIdException e) {
            throw new LicenseInstallationFailedException("Could not install license because the repository is locked to another license", e);
        }
        catch (LicenseViolationException e) {
            throw new LicenseInstallationFailedException("Could not install license because it is invalid", e);
        }
        catch (IOException e) {
            throw new LicenseInstallationFailedException("Could not install license due to problems with the file system", e);
        }
    }

    @Override
    public String getLicenseRenewalMessage() {
        if (!this.licenseFile.exists()) {
            return null;
        }
        try {
            this.licenseService.validate();
        }
        catch (LicenseVersionException e) {
            logger.info("License status: ", (Object)e.getMessage());
            return "Your license is of an old version.";
        }
        catch (LicensePeriodExpiredException e) {
            logger.info("License status: ", (Object)e.getMessage());
            return "Your license has expired.";
        }
        catch (LicenseEditionException e) {
            logger.info("License status: ", (Object)e.getMessage());
            License license = this.licenseService.getLicense();
            if (license != null && "Community".equals(license.getStringValue(LicenseProperty.EDITION))) {
                return String.format("This edition of %s cannot be used with a Community Edition license.", this.licenseService.getProduct());
            }
            return String.format("This edition of %s requires a Trial Edition license or an Enterprise Edition license.", this.licenseService.getProduct());
        }
        catch (AmountOfCisExceededException e) {
            logger.info("License status: ", (Object)e.getMessage());
            return "The number of configuration items in your repository exceeds the limit on this license.";
        }
        catch (LicenseViolationException e) {
            logger.info("License status: ", (Object)e.getMessage());
            return String.format("The current license is not valid (%s).", e.getMessage());
        }
        return "Enter a new license key to renew your license.";
    }

    private License readLicense(String licenseText) throws IOException {
        File tempFile = File.createTempFile("license", "tmp");
        Files.write((CharSequence)licenseText, (File)tempFile, (Charset)StandardCharsets.UTF_8);
        LicenseReader licenseReader = new LicenseReader();
        return licenseReader.readLicense(tempFile);
    }
}

