/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.testtools.fitnesse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TestSummary {
    public final List<String> hierarchy;
    public final Set<String> tags;
    public final long lastModified;
    public final int duration;
    public final int right;
    public final int wrong;
    public final String result;
    public final int exceptions;
    public final String firstError;

    public TestSummary(List<String> hierarchy, Set<String> tags, long lastModified, int duration, int right, int wrong, int exceptions, String firstError) {
        this.hierarchy = hierarchy;
        this.tags = tags;
        this.lastModified = lastModified;
        this.duration = duration;
        this.right = right;
        this.wrong = wrong;
        this.result = wrong + exceptions > 0 ? "FAILED" : "PASSED";
        this.exceptions = exceptions;
        this.firstError = firstError;
    }

    public int hashCode() {
        return Objects.hash(this.hierarchy, this.tags, this.lastModified, this.duration, this.right, this.wrong, this.result, this.exceptions, this.firstError);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestSummary that = (TestSummary)o;
        return Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.duration, that.duration) && Objects.equals(this.right, that.right) && Objects.equals(this.wrong, that.wrong) && Objects.equals(this.exceptions, that.exceptions) && Objects.equals(this.hierarchy, that.hierarchy) && Objects.equals(this.tags, that.tags) && Objects.equals(this.result, that.result) && Objects.equals(this.firstError, that.firstError);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("@hierarchy", this.hierarchy);
        map.put("@testedAt", this.lastModified);
        map.put("@duration", this.duration);
        map.put("right", this.right);
        map.put("wrong", this.wrong);
        map.put("@result", this.result);
        map.put("exceptions", this.exceptions);
        if (this.firstError != null) {
            map.put("@firstError", this.firstError);
        }
        return map;
    }
}

