/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.Map;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.configuration.ConditionalOnMissingBean;

class OnMissingBeanCondition
implements ConfigurationCondition {
    OnMissingBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attrs = metadata.getAnnotationAttributes(ConditionalOnMissingBean.class.getName());
        Class type = (Class)attrs.get("value");
        Map beans = context.getBeanFactory().getBeansOfType(type);
        return beans.isEmpty();
    }
}

