/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.authentication;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.authentication.PasswordEncoderParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AuthenticationProviderBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_USER_DETAILS_REF = "user-service-ref";

    public BeanDefinition parse(Element element, ParserContext pc) {
        String ref;
        Element userServiceElt;
        RootBeanDefinition authProvider = new RootBeanDefinition(DaoAuthenticationProvider.class);
        authProvider.setSource(pc.extractSource((Object)element));
        Element passwordEncoderElt = DomUtils.getChildElementByTagName((Element)element, (String)"password-encoder");
        if (passwordEncoderElt != null) {
            PasswordEncoderParser pep = new PasswordEncoderParser(passwordEncoderElt, pc);
            authProvider.getPropertyValues().addPropertyValue("passwordEncoder", (Object)pep.getPasswordEncoder());
            if (pep.getSaltSource() != null) {
                authProvider.getPropertyValues().addPropertyValue("saltSource", (Object)pep.getSaltSource());
            }
        }
        if ((userServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"user-service")) == null) {
            userServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"jdbc-user-service");
        }
        if (userServiceElt == null) {
            userServiceElt = DomUtils.getChildElementByTagName((Element)element, (String)"ldap-user-service");
        }
        if (StringUtils.hasText((String)(ref = element.getAttribute(ATT_USER_DETAILS_REF)))) {
            if (userServiceElt != null) {
                pc.getReaderContext().error("The user-service-ref attribute cannot be used in combination with childelements 'user-service', 'jdbc-user-service' or 'ldap-user-service'", (Object)element);
            }
            authProvider.getPropertyValues().add("userDetailsService", (Object)new RuntimeBeanReference(ref));
        } else {
            if (userServiceElt != null) {
                pc.getDelegate().parseCustomElement(userServiceElt, (BeanDefinition)authProvider);
            } else {
                pc.getReaderContext().error("A user-service is required", (Object)element);
            }
            String cacheRef = userServiceElt.getAttribute("cache-ref");
            if (StringUtils.hasText((String)cacheRef)) {
                authProvider.getPropertyValues().addPropertyValue("userCache", (Object)new RuntimeBeanReference(cacheRef));
            }
        }
        return authProvider;
    }
}

