/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v140;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.service.EventBulkProcessor;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AddSizeAttributeToEvents
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(AddSizeAttributeToEvents.class);
    public static final int BATCH_SIZE = 10;
    private final EventRepository eventRepository;

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.4.0#1");
    }

    @Autowired
    public AddSizeAttributeToEvents(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        this.eventRepository.refreshIndex();
        try {
            Map properties = Event.props((Object[])new Object[]{"type", "long", "index", "not_analyzed", "include_in_all", true});
            this.eventRepository.updateMapping("importFinished", "@size", properties);
            this.eventRepository.bulkUpdate("@type:importFinished", 10, new UpdateEventWithSizePropertyProcessor());
        }
        catch (Exception e) {
            throw new UpgradeException("Unable to perform upgrade", e);
        }
        this.eventRepository.refreshIndex();
        return true;
    }

    class UpdateEventWithSizePropertyProcessor
    implements EventBulkProcessor {
        UpdateEventWithSizePropertyProcessor() {
        }

        @Override
        public void process(List<Event> events) {
            LOG.debug("UpdateEventWithSizePropertyProcessor, Processing {} events.", (Object)events.size());
            events.stream().filter(event -> !event.hasProperty("@size")).forEach(this::updateEventWithSize);
        }

        private void updateEventWithSize(Event event) {
            TermFilterBuilder termFilterBuilder = FilterBuilders.termFilter((String)"@runId", (String)event.getTestRunId());
            long realCount = AddSizeAttributeToEvents.this.eventRepository.count((FilterBuilder)termFilterBuilder);
            event.update("@size", (Object)realCount);
            AddSizeAttributeToEvents.this.eventRepository.updateAndPersist(event);
        }
    }
}

