/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v140;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.service.EventBulkProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RenameSourceToCiSource
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(RenameSourceToCiSource.class);
    public static final int BATCH_SIZE = 10;
    private final EventRepository eventRepository;

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.4.0#2");
    }

    @Autowired
    public RenameSourceToCiSource(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        this.eventRepository.refreshIndex();
        try {
            this.eventRepository.bulkUpdate("@type:importStarted", 10, new RenameSourceToCiSourceProcessor());
            this.eventRepository.bulkUpdate("@type:functionalResult", 10, new RenameSourceToCiSourceProcessor());
            this.eventRepository.bulkUpdate("@type:performanceResult", 10, new RenameSourceToCiSourceProcessor());
            this.eventRepository.bulkUpdate("@type:importFinished", 10, new RenameSourceToCiSourceProcessor());
        }
        catch (Exception e) {
            throw new UpgradeException("Unable to perform upgrade", e);
        }
        this.eventRepository.refreshIndex();
        return true;
    }

    class RenameSourceToCiSourceProcessor
    implements EventBulkProcessor {
        RenameSourceToCiSourceProcessor() {
        }

        @Override
        public void process(List<Event> events) {
            LOG.debug("RenameSourceToCiSourceProcessor, Processing {} events.", (Object)events.size());
            events.stream().filter(event -> event.hasProperty("source")).forEach(this::renameSourceToCiSource);
        }

        private void renameSourceToCiSource(Event event) {
            this.replaceKey(event, "source", "ciSource");
            RenameSourceToCiSource.this.eventRepository.updateAndPersist(event);
        }

        public void replaceKey(Event event, String oldKey, String newKey) {
            Object value = event.get(oldKey);
            if (value != null) {
                event.update(newKey, value);
                event.remove(oldKey);
            }
        }
    }
}

