/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static File extractZipInputStreamToTempLocalTempDirectory(InputStream inputStream) throws IOException {
        File localTempDir = Files.createTempDir();
        FileUtil.extractZipInputStream(localTempDir, inputStream);
        LOG.info("Extracted zip content into: " + localTempDir.getAbsolutePath());
        return localTempDir;
    }

    private static void extractZipInputStream(File baseDir, InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(baseDir, entry.getName());
            LOG.debug("Copying {} into file {}", (Object)entry.getName(), (Object)file);
            Files.createParentDirs((File)file);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zis), (File)file);
        }
    }
}

