/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.merge.OnGoingMerge;

public class TrackingConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    protected final ESLogger logger;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();
    private final Set<OnGoingMerge> onGoingMerges = ConcurrentCollections.newConcurrentSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);

    public TrackingConcurrentMergeScheduler(ESLogger logger) {
        this.logger = logger;
    }

    public long totalMerges() {
        return this.totalMerges.count();
    }

    public long totalMergeTime() {
        return this.totalMerges.sum();
    }

    public long totalMergeNumDocs() {
        return this.totalMergesNumDocs.count();
    }

    public long totalMergeSizeInBytes() {
        return this.totalMergesSizeInBytes.count();
    }

    public long currentMerges() {
        return this.currentMerges.count();
    }

    public long currentMergesNumDocs() {
        return this.currentMergesNumDocs.count();
    }

    public long currentMergesSizeInBytes() {
        return this.currentMergesSizeInBytes.count();
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMerge(MergePolicy.OneMerge merge) throws IOException {
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        long timeNS = System.nanoTime();
        this.currentMerges.inc();
        this.currentMergesNumDocs.inc(totalNumDocs);
        this.currentMergesSizeInBytes.inc(totalSizeInBytes);
        OnGoingMerge onGoingMerge = new OnGoingMerge(merge);
        this.onGoingMerges.add(onGoingMerge);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting..., merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", merge.info == null ? "_na_" : merge.info.info.name, merge.segments.size(), totalNumDocs, new ByteSizeValue(totalSizeInBytes), new ByteSizeValue(merge.estimatedMergeBytes));
        }
        try {
            this.beforeMerge(onGoingMerge);
            super.doMerge(merge);
        }
        catch (Throwable throwable) {
            long tookMS = TimeValue.nsecToMSec(System.nanoTime() - timeNS);
            this.onGoingMerges.remove(onGoingMerge);
            this.afterMerge(onGoingMerge);
            this.currentMerges.dec();
            this.currentMergesNumDocs.dec(totalNumDocs);
            this.currentMergesSizeInBytes.dec(totalSizeInBytes);
            this.totalMergesNumDocs.inc(totalNumDocs);
            this.totalMergesSizeInBytes.inc(totalSizeInBytes);
            this.totalMerges.inc(tookMS);
            String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs]", merge.info == null ? "_na_" : merge.info.info.name, TimeValue.timeValueMillis(tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs);
            if (tookMS > 20000L) {
                this.logger.debug(message, new Object[0]);
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace(message, new Object[0]);
            }
            throw throwable;
        }
        long tookMS = TimeValue.nsecToMSec(System.nanoTime() - timeNS);
        this.onGoingMerges.remove(onGoingMerge);
        this.afterMerge(onGoingMerge);
        this.currentMerges.dec();
        this.currentMergesNumDocs.dec(totalNumDocs);
        this.currentMergesSizeInBytes.dec(totalSizeInBytes);
        this.totalMergesNumDocs.inc(totalNumDocs);
        this.totalMergesSizeInBytes.inc(totalSizeInBytes);
        this.totalMerges.inc(tookMS);
        String message = String.format(Locale.ROOT, "merge segment [%s] done: took [%s], [%,.1f MB], [%,d docs]", merge.info == null ? "_na_" : merge.info.info.name, TimeValue.timeValueMillis(tookMS), Float.valueOf((float)totalSizeInBytes / 1024.0f / 1024.0f), totalNumDocs);
        if (tookMS > 20000L) {
            this.logger.debug(message, new Object[0]);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace(message, new Object[0]);
        }
    }

    protected void beforeMerge(OnGoingMerge merge) {
    }

    protected void afterMerge(OnGoingMerge merge) {
    }

    public MergeScheduler clone() {
        return this;
    }
}

