/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesInfoAction
extends TransportNodesOperationAction<NodesInfoRequest, NodesInfoResponse, NodeInfoRequest, NodeInfo> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesInfoAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters) {
        super(settings, "cluster:monitor/nodes/info", clusterName, threadPool, clusterService, transportService, actionFilters);
        this.nodeService = nodeService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected NodesInfoResponse newResponse(NodesInfoRequest nodesInfoRequest, AtomicReferenceArray responses) {
        ArrayList<NodeInfo> nodesInfos = new ArrayList<NodeInfo>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeInfo)) continue;
            nodesInfos.add((NodeInfo)resp);
        }
        return new NodesInfoResponse(this.clusterName, nodesInfos.toArray(new NodeInfo[nodesInfos.size()]));
    }

    @Override
    protected NodesInfoRequest newRequest() {
        return new NodesInfoRequest();
    }

    @Override
    protected NodeInfoRequest newNodeRequest() {
        return new NodeInfoRequest();
    }

    @Override
    protected NodeInfoRequest newNodeRequest(String nodeId, NodesInfoRequest request) {
        return new NodeInfoRequest(nodeId, request);
    }

    @Override
    protected NodeInfo newNodeResponse() {
        return new NodeInfo();
    }

    @Override
    protected NodeInfo nodeOperation(NodeInfoRequest nodeRequest) throws ElasticsearchException {
        NodesInfoRequest request = nodeRequest.request;
        return this.nodeService.info(request.settings(), request.os(), request.process(), request.jvm(), request.threadPool(), request.network(), request.transport(), request.http(), request.plugins());
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    static class NodeInfoRequest
    extends NodeOperationRequest {
        NodesInfoRequest request;

        NodeInfoRequest() {
        }

        NodeInfoRequest(String nodeId, NodesInfoRequest request) {
            super(request, nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesInfoRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

