/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.HasRestHeaders;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;

    public BytesRestResponse(RestStatus status) {
        this(status, TEXT_CONTENT_TYPE, BytesArray.EMPTY);
    }

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().restContentType(), builder.bytes());
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Throwable t) throws IOException {
        this(channel, t instanceof ElasticsearchException ? ((ElasticsearchException)t).status() : RestStatus.INTERNAL_SERVER_ERROR, t);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Throwable t) throws IOException {
        this.status = status;
        if (channel.request().method() == RestRequest.Method.HEAD) {
            this.content = BytesArray.EMPTY;
            this.contentType = TEXT_CONTENT_TYPE;
        } else {
            XContentBuilder builder = BytesRestResponse.convert(channel, status, t);
            this.content = builder.bytes();
            this.contentType = builder.contentType().restContentType();
        }
        if (t instanceof HasRestHeaders) {
            this.addHeaders(((HasRestHeaders)((Object)t)).getHeaders());
        }
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    private static XContentBuilder convert(RestChannel channel, RestStatus status, Throwable t) throws IOException {
        XContentBuilder builder = channel.newErrorBuilder().startObject();
        if (t == null) {
            builder.field("error", "Unknown");
        } else if (channel.detailedErrorsEnabled()) {
            builder.field("error", ExceptionsHelper.detailedMessage(t));
            if (channel.request().paramAsBoolean("error_trace", false)) {
                BytesRestResponse.buildErrorTrace(t, builder);
            }
        } else {
            builder.field("error", BytesRestResponse.simpleMessage(t));
        }
        builder.field("status", status.getStatus());
        builder.endObject();
        return builder;
    }

    private static void buildErrorTrace(Throwable t, XContentBuilder builder) throws IOException {
        builder.startObject("error_trace");
        boolean first = true;
        int counter = 0;
        while (t != null && counter++ <= 10) {
            if (!first) {
                builder.startObject("cause");
            }
            BytesRestResponse.buildThrowable(t, builder);
            if (!first) {
                builder.endObject();
            }
            t = t.getCause();
            first = false;
        }
        builder.endObject();
    }

    private static void buildThrowable(Throwable t, XContentBuilder builder) throws IOException {
        builder.field("message", t.getMessage());
        for (StackTraceElement stElement : t.getStackTrace()) {
            builder.startObject("at").field("class", stElement.getClassName()).field("method", stElement.getMethodName());
            if (stElement.getFileName() != null) {
                builder.field("file", stElement.getFileName());
            }
            if (stElement.getLineNumber() >= 0) {
                builder.field("line", stElement.getLineNumber());
            }
            builder.endObject();
        }
    }

    private static String simpleMessage(Throwable t) throws IOException {
        int counter = 0;
        for (Throwable next = t; next != null && counter++ < 10; next = next.getCause()) {
            if (!(t instanceof ElasticsearchException)) continue;
            return next.getClass().getSimpleName() + "[" + next.getMessage() + "]";
        }
        return "No ElasticsearchException found";
    }
}

