/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.Protocol;
import org.jgroups.util.CondVar;
import org.jgroups.util.Condition;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Responses;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Protocol to discover subgroups existing due to a network partition")
@Deprecated
public class MERGE2
extends Protocol {
    @Property(description="Minimum time in ms between runs to discover other clusters")
    protected long min_interval = 5000L;
    @Property(description="Maximum time in ms between runs to discover other clusters")
    protected long max_interval = 20000L;
    @Property(description="Number of inconsistent  views with only 1 coord after a MERGE event is sent up")
    protected int inconsistent_view_threshold = 1;
    @Property(description="When receiving a multicast message, checks if the sender is member of the cluster. If not, initiates a merge. Generates a lot of traffic for large clusters when there is a lot of merging")
    protected boolean merge_fast = true;
    @Property(description="The delay (in milliseconds) after which a merge fast execution is started")
    protected long merge_fast_delay = 1000L;
    @Property(description="Always sends a discovery response, no matter what", writable=true)
    protected boolean force_sending_discovery_rsps = true;
    @Property(description="Time (in ms) to wait for all discovery responses")
    protected long discovery_timeout = 5000L;
    protected Address local_addr;
    protected volatile View view;
    protected final Set<Address> members = new HashSet<Address>();
    protected final Set<Address> merge_candidates = new CopyOnWriteArraySet<Address>();
    protected final FindSubgroupsTask task = new FindSubgroupsTask();
    @ManagedAttribute(description="Whether this member is the current coordinator")
    protected volatile boolean is_coord = false;
    protected volatile Address current_coord;
    protected TimeScheduler timer;
    @ManagedAttribute(description="Number of inconsistent 1-coord views until a MERGE event is sent up the stack")
    protected int num_inconsistent_views;
    @ManagedAttribute(description="Number of times a MERGE event was sent up the stack")
    protected int num_merge_events;
    protected final Map<Address, View> views = new ConcurrentHashMap<Address, View>();
    protected final Lock discovery_lock = new ReentrantLock();
    protected final CondVar discovery_cond = new CondVar(this.discovery_lock);
    protected volatile boolean fetching_done = false;
    protected boolean transport_supports_multicasting = true;
    protected String cluster_name;

    @ManagedAttribute(writable=false, description="whether or not a merge task is currently running (should be the case in a coordinator")
    public boolean isMergeTaskRunning() {
        return this.task.isRunning();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            throw new Exception("min_interval and max_interval have to be > 0");
        }
        if (this.max_interval <= this.min_interval) {
            throw new Exception("max_interval has to be greater than min_interval");
        }
        this.transport_supports_multicasting = this.getTransport().supportsMulticasting();
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public void setMinInterval(long i) {
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public void setMaxInterval(long l) {
        this.max_interval = l;
    }

    protected boolean isMergeRunning() {
        Object retval = this.up_prot.up(new Event(100));
        return retval instanceof Boolean && (Boolean)retval != false;
    }

    @ManagedOperation
    public void sendMergeSolicitation() {
        this.task.findAndNotify();
    }

    @ManagedAttribute(description="The address of the current coordinator")
    public String getCurrentCoord() {
        return this.current_coord != null ? this.current_coord.toString() : "n/a";
    }

    @ManagedOperation
    public void startMergeTask() {
        this.task.start();
    }

    @ManagedOperation
    public void stopMergeTask() {
        this.task.stop();
    }

    @ManagedOperation(description="Fetches all views")
    public String fetchAllViews() {
        try {
            this.task.fetchViews();
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Address, View> entry : this.views.entrySet()) {
                sb.append(entry.getKey() + ": " + entry.getValue() + "\n");
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void stop() {
        this.is_coord = false;
        this.merge_candidates.clear();
        this.task.stop();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.cluster_name = (String)evt.getArg();
                return this.down_prot.down(evt);
            }
            case 6: {
                Object ret = this.down_prot.down(evt);
                this.view = (View)evt.getArg();
                List<Address> mbrs = this.view.getMembers();
                if (mbrs == null || mbrs.isEmpty() || this.local_addr == null) {
                    this.task.stop();
                    return ret;
                }
                this.members.clear();
                this.members.addAll(mbrs);
                this.merge_candidates.removeAll(this.members);
                Address address = this.current_coord = mbrs.isEmpty() ? null : mbrs.get(0);
                if (this.current_coord != null && this.current_coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.task.start();
                } else {
                    this.is_coord = false;
                    this.task.stop();
                }
                return ret;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                MergeHeader hdr = (MergeHeader)msg.getHeader(this.id);
                if (hdr == null) {
                    if (!this.merge_fast) break;
                    this.mergeFast(msg.dest(), msg.src());
                    break;
                }
                this.handle(hdr, msg.src());
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            MergeHeader hdr = (MergeHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            batch.remove(msg);
            this.handle(hdr, batch.sender());
        }
        if (!batch.isEmpty()) {
            if (this.merge_fast) {
                this.mergeFast(batch.dest(), batch.sender());
            }
            this.up_prot.up(batch);
        }
    }

    protected void mergeFast(Address dest, final Address sender) {
        if (dest == null && !this.members.contains(sender) && this.merge_candidates.add(sender)) {
            this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    if (!MERGE2.this.members.contains(sender)) {
                        MERGE2.this.task.findAndNotify();
                    }
                }
            }, this.merge_fast_delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(MergeHeader hdr, Address sender) {
        switch (hdr.type) {
            case 1: {
                boolean send_discovery_rsp;
                boolean bl = send_discovery_rsp = this.force_sending_discovery_rsps || this.is_coord || this.current_coord == null || this.current_coord.equals(sender);
                if (!send_discovery_rsp) {
                    this.log.trace("%s: suppressing discovery response as I'm not a coordinator and the discovery request was not sent by a coordinator", this.local_addr);
                    return;
                }
                if (this.isMergeRunning()) {
                    this.log.trace("%s: suppressing discovery response as a merge is in progress", this.local_addr);
                    return;
                }
                if (this.view == null) break;
                Message msg = new Message(sender).putHeader(this.id, new MergeHeader(2, this.view));
                this.down_prot.down(new Event(1, msg));
                break;
            }
            case 2: {
                View rsp_view = hdr.view;
                if (rsp_view == null || this.fetching_done) break;
                this.views.put(sender, rsp_view);
                List<View> diff_views = Util.detectDifferentViews(this.views);
                if (diff_views.size() <= 1) break;
                this.discovery_lock.lock();
                try {
                    this.fetching_done = true;
                    this.discovery_cond.signal(true);
                    break;
                }
                finally {
                    this.discovery_lock.unlock();
                }
            }
        }
    }

    protected static class MergeHeader
    extends Header {
        protected byte type = 1;
        protected View view;
        protected static final byte REQ = 1;
        protected static final byte RSP = 2;

        public MergeHeader() {
        }

        public MergeHeader(byte type, View view) {
            this.type = type;
            this.view = view;
        }

        @Override
        public String toString() {
            return (this.type == 1 ? "req" : "rsp") + ", view=" + this.view;
        }

        @Override
        public int size() {
            return 1 + Util.size(this.view);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeView(this.view, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.view = Util.readView(in);
        }
    }

    protected class FindSubgroupsTask
    implements Condition {
        protected Future<?> future;
        protected final Lock lock = new ReentrantLock();

        protected FindSubgroupsTask() {
        }

        public synchronized void start() {
            if (this.future == null || this.future.isDone()) {
                this.future = MERGE2.this.timer.scheduleWithDynamicInterval(new TimeScheduler.Task(){

                    @Override
                    public long nextInterval() {
                        return FindSubgroupsTask.this.computeInterval();
                    }

                    @Override
                    public void run() {
                        FindSubgroupsTask.this.findAndNotify();
                    }

                    public String toString() {
                        return MERGE2.class.getSimpleName() + ": " + this.getClass().getSimpleName();
                    }
                });
            }
        }

        public synchronized void stop() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }

        public synchronized boolean isRunning() {
            return this.future != null && !this.future.isDone();
        }

        @Override
        public boolean isMet() {
            return MERGE2.this.fetching_done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void findAndNotify() {
            if (MERGE2.this.isMergeRunning()) {
                return;
            }
            if (this.lock.tryLock()) {
                try {
                    this._findAndNotify();
                }
                catch (InterruptedException iex) {
                }
                catch (Throwable t) {
                    MERGE2.this.log.error("FindSubgroupsTask failed", t);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        protected void _findAndNotify() throws InterruptedException {
            List<View> different_views;
            this.fetchViews();
            if (MERGE2.this.log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(MERGE2.this.local_addr + ": discovery results:\n");
                for (Map.Entry<Address, View> entry : MERGE2.this.views.entrySet()) {
                    sb.append("[" + entry.getKey() + "]: " + entry.getValue().getViewId()).append("\n");
                }
                MERGE2.this.log.trace(sb);
            }
            if ((different_views = Util.detectDifferentViews(MERGE2.this.views)).size() <= 1) {
                MERGE2.this.num_inconsistent_views = 0;
                return;
            }
            Collection<Address> merge_participants = Util.determineMergeParticipants(MERGE2.this.views);
            if (merge_participants.size() == 1) {
                if (MERGE2.this.num_inconsistent_views < MERGE2.this.inconsistent_view_threshold) {
                    MERGE2.this.log.debug("%s: dropping MERGE for inconsistent views (%s) as inconsistent view threshold (%d) has not yet been reached (%d)", MERGE2.this.local_addr, Util.printViews(different_views), MERGE2.this.inconsistent_view_threshold, MERGE2.this.num_inconsistent_views);
                    ++MERGE2.this.num_inconsistent_views;
                    return;
                }
                MERGE2.this.num_inconsistent_views = 0;
            } else {
                MERGE2.this.num_inconsistent_views = 0;
            }
            if (MERGE2.this.log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(MERGE2.this.local_addr + " found different views : " + Util.printViews(different_views) + "; sending up MERGE event with merge participants " + merge_participants + ".\n");
                sb.append("Discovery results:\n");
                for (Map.Entry<Address, View> entry : MERGE2.this.views.entrySet()) {
                    sb.append("[" + entry.getKey() + "]: coord=" + entry.getValue().getCreator()).append("\n");
                }
                MERGE2.this.log.debug(sb.toString());
            }
            Event evt = new Event(14, MERGE2.this.views);
            try {
                MERGE2.this.up_prot.up(evt);
                ++MERGE2.this.num_merge_events;
            }
            catch (Throwable t) {
                MERGE2.this.log.error("failed sending up MERGE event", t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fetchViews() throws InterruptedException {
            MERGE2.this.views.clear();
            View tmp_view = MERGE2.this.view;
            if (tmp_view != null) {
                MERGE2.this.views.put(MERGE2.this.local_addr, tmp_view);
            }
            MERGE2.this.fetching_done = false;
            if (MERGE2.this.transport_supports_multicasting) {
                Message discovery_req = new Message(null).putHeader(MERGE2.this.id, new MergeHeader(1, null)).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
                MERGE2.this.down_prot.down(new Event(1, discovery_req));
                return;
            }
            Responses rsps = (Responses)MERGE2.this.down_prot.down(Event.FIND_MBRS_EVT);
            rsps.waitFor(MERGE2.this.discovery_timeout);
            if (rsps.isEmpty()) {
                return;
            }
            MERGE2.this.log.trace("discovery protocol returned %d responses: %s", rsps.size(), rsps);
            for (PingData rsp : rsps) {
                PhysicalAddress addr = rsp.getPhysicalAddr();
                if (addr == null) continue;
                Message discovery_req = new Message(addr).putHeader(MERGE2.this.id, new MergeHeader(1, null)).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK);
                MERGE2.this.down_prot.down(new Event(1, discovery_req));
            }
            try {
                MERGE2.this.discovery_cond.waitFor(this, MERGE2.this.discovery_timeout, TimeUnit.MILLISECONDS);
            }
            finally {
                MERGE2.this.fetching_done = true;
            }
        }

        protected long computeInterval() {
            return MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
        }
    }
}

