/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.AddCacheManagerListenerAction;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheConfigurationAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return Security.doPrivileged(action);
    }

    static void addCacheManagerListener(EmbeddedCacheManager cache, Object listener) {
        AddCacheManagerListenerAction action = new AddCacheManagerListenerAction(cache, listener);
        SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return SecurityActions.doPrivileged(action);
    }

    static ComponentRegistry getCacheComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return SecurityActions.doPrivileged(action);
    }
}

