/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.testHistory.HistoryComparer;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class HistoryComparerResponder
implements Responder {
    public HistoryComparer comparer;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String firstFileName = "";
    private String secondFileName = "";
    private String firstFilePath;
    private String secondFilePath;
    public boolean testing = false;
    private FitNesseContext context;

    public HistoryComparerResponder(HistoryComparer historyComparer) {
        this.comparer = historyComparer;
    }

    public HistoryComparerResponder() {
        this.comparer = new HistoryComparer();
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        this.initializeReponseComponents();
        if (!this.getFileNameFromRequest(request)) {
            return this.makeErrorResponse(context, request, "Compare Failed because the wrong number of Input Files were given. Select two please.");
        }
        this.firstFilePath = this.composeFileName(request, this.firstFileName);
        this.secondFilePath = this.composeFileName(request, this.secondFileName);
        if (!this.filesExist()) {
            return this.makeErrorResponse(context, request, "Compare Failed because the files were not found.");
        }
        return this.makeResponseFromComparison(context, request);
    }

    private Response makeResponseFromComparison(FitNesseContext context, Request request) throws IOException, SAXException {
        if (this.comparer.compare(this.firstFilePath, this.secondFilePath)) {
            return this.makeValidResponse(request);
        }
        String message = String.format("These files could not be compared.  They might be suites, or something else might be wrong.", new Object[0]);
        return this.makeErrorResponse(context, request, message);
    }

    private boolean filesExist() {
        return new File(this.firstFilePath).exists() || new File(this.secondFilePath).exists();
    }

    private void initializeReponseComponents() {
        if (this.comparer == null) {
            this.comparer = new HistoryComparer();
        }
    }

    private String composeFileName(Request request, String fileName) {
        return this.context.getTestHistoryDirectory().getPath() + File.separator + request.getResource() + File.separator + fileName;
    }

    private boolean getFileNameFromRequest(Request request) {
        this.firstFileName = "";
        this.secondFileName = "";
        Map<String, String> inputs = request.getMap();
        Set<String> keys = inputs.keySet();
        return this.setFileNames(keys);
    }

    private boolean setFileNames(Set<String> keys) {
        for (String key : keys) {
            if (!key.contains("TestResult_") || !this.setFileNames(key)) continue;
            return false;
        }
        return !this.firstFileName.equals("") && !this.secondFileName.equals("");
    }

    private boolean setFileNames(String key) {
        if (this.firstFileName.equals("")) {
            this.firstFileName = key.substring(key.indexOf("_") + 1);
        } else if (this.secondFileName.equals("")) {
            this.secondFileName = key.substring(key.indexOf("_") + 1);
        } else {
            return true;
        }
        return false;
    }

    private Response makeValidResponse(Request request) {
        int count = 0;
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("History Comparison");
        page.setPageTitle(this.makePageTitle(request.getResource()));
        if (!this.testing) {
            page.put("firstFileName", this.formatDate(this.firstFileName));
            page.put("secondFileName", this.formatDate(this.secondFileName));
            page.put("completeMatch", this.comparer.allTablesMatch());
            page.put("comparer", this.comparer);
        }
        page.put("resultContent", this.comparer.getResultContent());
        page.put("firstTables", this.comparer.firstTableResults);
        page.put("secondTables", this.comparer.secondTableResults);
        page.put("count", count);
        page.setMainTemplate("compareHistory");
        SimpleResponse response = new SimpleResponse();
        response.setContent(page.html());
        return response;
    }

    private Date formatDate(String fileName) {
        try {
            return this.dateFormat.parse(this.firstFileName);
        }
        catch (ParseException e) {
            throw new RuntimeException("File name '" + fileName + "' does not parse to a date", e);
        }
    }

    private PageTitle makePageTitle(String resource) {
        String tags = "";
        if (this.context.getRootPage() != null) {
            WikiPagePath path = PathParser.parse(resource);
            PageCrawler crawler = this.context.getRootPage().getPageCrawler();
            WikiPage wikiPage = crawler.getPage(path);
            if (wikiPage != null) {
                PageData pageData = wikiPage.getData();
                tags = pageData.getAttribute("Suites");
            }
        }
        return new PageTitle("Test History", PathParser.parse(resource), tags);
    }

    private Response makeErrorResponse(FitNesseContext context, Request request, String message) {
        return new ErrorResponder(message).makeResponse(context, request);
    }
}

