/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;

public class ReaderChunker {
    private final Reader reader;
    private final char start0;
    private final char start1;
    private final char end0;
    private final char end1;
    private static final int BUFFER_SIZE = 1024;
    private int bufferSize;
    private StringBuilder builder = new StringBuilder();
    private StringBuilder residual = new StringBuilder();
    private boolean appended = false;

    @VisibleForTesting
    ReaderChunker(Reader reader, String delimiters, int bufferSize) {
        this.reader = reader;
        this.bufferSize = bufferSize;
        String[] split = delimiters.split(" ");
        this.start0 = split[0].charAt(0);
        this.start1 = split[0].charAt(1);
        this.end0 = split[1].charAt(0);
        this.end1 = split[1].charAt(1);
    }

    public ReaderChunker(Reader reader, String delimiters) {
        this(reader, delimiters, 1024);
    }

    public Reader next() {
        this.resetBuilders();
        char[] buffer = new char[this.bufferSize];
        String chunk = this.buildChunk(buffer);
        return chunk.isEmpty() ? null : new StringReader(chunk);
    }

    private void resetBuilders() {
        this.builder = new StringBuilder();
        this.builder.append(this.residual.toString());
        this.residual = new StringBuilder();
    }

    private String buildChunk(char[] buffer) {
        boolean reading = false;
        try {
            int x;
            while ((x = this.reader.read(buffer)) > 0) {
                this.appended = false;
                if (x < buffer.length) {
                    buffer = Arrays.copyOf(buffer, x);
                }
                if (this.builder.length() > 0 && buffer[0] == this.end0 && this.builder.charAt(this.builder.length() - 1) == this.end1) {
                    this.finishScan(buffer, 1);
                    break;
                }
                if (this.scan(buffer, reading) && buffer[x - 1] != this.start0) {
                    if (!reading) {
                        this.builder.append(buffer, 0, x);
                    }
                    break;
                }
                this.appendBufferIfNotDoneByScan(buffer, x);
                reading = true;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception Occured while retrieving next chunk from the reader", e);
        }
        return this.builder.toString();
    }

    private void appendBufferIfNotDoneByScan(char[] buffer, int x) {
        if (!this.appended) {
            this.appendResidualToChunkAndReset();
            this.builder.append(buffer, 0, x);
        }
    }

    private void appendResidualToChunkAndReset() {
        if (this.residual.length() > 0) {
            this.builder.append(this.residual.toString());
            this.residual = new StringBuilder();
        }
    }

    private boolean scan(char[] buffer, boolean reading) {
        if (reading) {
            return this.placeStartMarkers(buffer);
        }
        for (int i = buffer.length - 1; i > 0; --i) {
            if (buffer[i] == this.end1 && buffer[i - 1] == this.end0) {
                return true;
            }
            if (buffer[i] != this.start1 || buffer[i - 1] != this.start0) continue;
            return false;
        }
        return !reading;
    }

    private boolean placeStartMarkers(char[] buffer) {
        for (int i = 0; i < buffer.length - 2; ++i) {
            if (buffer[i] == this.end0 && buffer[i + 1] == this.end1) {
                this.finishScan(buffer, i + 2);
                return true;
            }
            if (buffer[i] != this.start0 || buffer[i + 1] != this.start1) continue;
            this.finishScan(buffer, i);
            return false;
        }
        return false;
    }

    private void finishScan(char[] buffer, int offset) {
        this.appendResidualToChunkAndReset();
        this.builder.append(buffer, 0, offset);
        this.residual.append(buffer, offset, buffer.length - offset);
        this.appended = true;
    }
}

