import json

from java.io import File
from com.xebialabs.xlt.plugin.api.resultparser.performance import PerformanceResultsSummary
from parser.performance import performance_test_result_parser
from parser.xunit import open_file

def parse_percentiles_and_put_on_map(data, other_properties, key):
    other_properties[key + ".total"] = int(data[key]["total"])
    other_properties[key + ".ok"] = int(data[key]["ok"])
    other_properties[key + ".ko"] = int(data[key]["ko"])


def parse_group_and_put_on_map(data, other_properties, key):
    other_properties[key + ".name"] = data[key]["name"]
    other_properties[key + ".count"] = int(data[key]["count"])
    other_properties[key + ".percentage"] = int(data[key]["percentage"])

class Line:
    words = None

    def __init__(self, line):
        self.words = line.split('\t')

    def run_line(self):
        return self.words[2] == "RUN"

    def start_line(self):
        print self.words
        return self.words[3] == "START"

    def end_line(self):
        print self.words
        return self.words[3] == "END"

    def start_time(self):
        if self.start_line() or self.end_line():
            return int(self.words[4])

        if self.run_line():
            return int(self.words[3])

        raise RuntimeError("You can't derive the start time from a non START, END, or RUN line: " + str(self.words))

    def end_time(self):
        if self.end_line():
            return int(self.words[5])

        raise RuntimeError("You can't derive the end time from a non END line: " + str(self.words))

    def simulation_name(self):
        if self.run_line():
            return self.words[1]

        raise RuntimeError("Simulation name can only be retrieved from first line of the log")


class GatlingParser(object):

    def __init__(self):
        self.simulation_name = None
        self.start_time = None
        self.run_key = None

    def filter_readable(self, blob):
        result = []
        for file in blob:
            if str(file).endswith("log") or str(file).endswith("json"):
                result.append(file)
        return result

    def construct_performance_results_summary(self, file):
        if str(file).endswith("json"):
            return
        result = PerformanceResultsSummary()

        # Throw out this run if we have parsed this directory before
        self.run_key = file.getParentFile().getName()
        if test_run_historian.isKnownKey(self.run_key):
            return

        # read start and end time from simulation.log so that we can calculate duration
        lines = [line.rstrip('\n') for line in open_file(file)]
        first_line = Line(lines[0])
        last_line = Line(lines[-1])

        # remember simulation name so that we can enrich the import started event with it
        self.simulation_name = first_line.simulation_name()
        self.start_time = first_line.start_time()

        # read totals from global_stats.json
        global_stats_path = file.getParentFile().getPath() + File.separator + "js" + File.separator + "global_stats.json"
        with open(global_stats_path) as data_file:
            data = json.load(data_file)

            result.setEarliestTimestamp(first_line.start_time())
            result.setLatestTimestamp(last_line.end_time())

            result.setTotalNumberOfRequests(int(data["numberOfRequests"]["total"]))
            result.setTotalNumberOfOkRequests(int(data["numberOfRequests"]["ok"]))
            result.setTotalNumberOfNotOkRequests(int(data["numberOfRequests"]["ko"]))

            result.setMinResponseTime(int(data["minResponseTime"]["total"]))
            result.setMinResponseTimeOk(int(data["minResponseTime"]["ok"]))
            result.setMinResponseTimeNotOk(int(data["minResponseTime"]["ko"]))

            result.setMaxResponseTime(int(data["maxResponseTime"]["total"]))
            result.setMaxResponseTimeOk(int(data["maxResponseTime"]["ok"]))
            result.setMaxResponseTimeNotOk(int(data["maxResponseTime"]["ko"]))

            result.setMeanResponseTime(int(data["meanResponseTime"]["total"]))
            result.setMeanResponseTimeOk(int(data["meanResponseTime"]["ok"]))
            result.setMeanResponseTimeNotOk(int(data["meanResponseTime"]["ko"]))

            result.setStandardDeviation(int(data["standardDeviation"]["total"]))
            result.setStandardDeviationOk(int(data["standardDeviation"]["ok"]))
            result.setStandardDeviationNotOk(int(data["standardDeviation"]["ko"]))

            other_properties = {}
            parse_percentiles_and_put_on_map(data, other_properties, "percentiles1")
            parse_percentiles_and_put_on_map(data, other_properties, "percentiles2")
            parse_group_and_put_on_map(data, other_properties, "group1")
            parse_group_and_put_on_map(data, other_properties, "group2")
            parse_group_and_put_on_map(data, other_properties, "group3")
            parse_group_and_put_on_map(data, other_properties, "group4")

            result.setOtherProperties(other_properties)


        return result

    def enrich_import_started_event(self, importStartedEvent):
        importStartedEvent.setSimulationName(self.simulation_name)
        importStartedEvent.setTestedAt(self.start_time)
        importStartedEvent.setRunKey(self.run_key)

result_holder.result = performance_test_result_parser(files, test_run_historian=test_run_historian, parser=GatlingParser())
