# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.flakiness import Flakiness

from modules.hierarchy import *

prefixParam = get_prefix_param(query_parameters)
prefixArray = get_prefix_array(query_parameters)

paramDate = query_parameters.get('date')
paramRange = query_parameters.get('range')

def flakiness():
    query_parameters['testsToShow'] = 4

    flakiness = Flakiness(test_run, test_runs, query_parameters, start_date, end_date, tags)
    flakiness_result = flakiness.getFlakinessResult()
    print "flakiness_result ", flakiness_result
    flakiness_result['dates'] = flakiness_result['dates'][0:10]
    for each_test in flakiness_result['tests']:
        each_test['results'] = each_test['results'][0:10]

    flakiness_result['url'] = '/testspecifications/' + test_run.testSpecificationName + '/report/xlt.FlakinessOverview'
    flakiness_result['params'] = [{'prefix': '', 'date': paramDate, 'range': paramRange}]
    return flakiness_result


def failures_guage():
    events = test_runs.getEventsForTestRun(test_run, {})

    passed = 0
    failed = 0
    other = 0
    if events:
        for event in events:
            if is_functional_result(event):
                if not prefix_within_hierarchy(event, prefixArray):
                    continue
                result = event.getResult()
                if result is None:
                    continue
                if result == 'PASSED':
                    passed += 1
                elif result == 'OTHER':
                    other += 1
                else:
                    failed += 1

    total_results = passed + failed + other
    return {
        'chart': {
            'type': 'solidgauge',
            'margin': 0,
            'events': {
                'click': '/testspecifications/' + test_run.testSpecificationName + '/report/xlt.Details'
            }
        },

        'title': None,

        'pane': {
            'center': ['50%', '85%'],
            'size': '140%',
            'startAngle': -90,
            'endAngle': 90,
            'background': {
                'backgroundColor': '#9ADA7F',
                'innerRadius': '60%',
                'outerRadius': '100%',
                'shape': 'arc',
                'borderColor': 'transparent'
            }
        },

        'tooltip': {
            'enabled': False
        },

        # the value axis
        'yAxis': {
            'stops': [
                [1.0, '#fd8d10']  # yellow
            ],
            'lineWidth': 0,
            'minorTickInterval': None,
            'tickPixelInterval': total_results,
            'tickWidth': 0,
            'labels': {
                'enabled': False
            },
            'min': 0,
            'max': total_results,
        },

        'plotOptions': {
            'solidgauge': {
                'dataLabels': {
                    'y': 4,
                    'borderWidth': 0,
                    'useHTML': True,
                    'format': '<div class="text-center">{y}<br/>' +
                              'of ' + str(total_results) + '<br/>' +
                              'failed</div>',
                    'style': {
                        'fontWeight': 'normal',
                        'fontSize': '10px',
                        # 'color': '#606060',
                        'textAlign': 'center'
                    }
                }
            }
        },

        'series': [{
                     'name': 'Failures',
                     'data': [failed]
                 },
                 {
                     'name': 'Other',
                     'data': [other]
                 }]
    }


def duration_trend():
    durations = []
    run_times = []

    prefix = prefixParam

    for r in test_runs.getTestRunsBetween(test_run.testSpecificationName, start_date.getTime(), end_date.getTime()):
        duration = 0
        prefixEvents = test_runs.getEventsForTestRun(r, {'@hierarchy': prefixArray})

        for event in (e for e in prefixEvents if is_functional_result(e)):
            duration += event.get("@duration") or 0
            if not prefix:
                hierarchy = get_hierarchy(event)
                if len(hierarchy) > 0:
                    prefix = hierarchy[0]

        durations.append({'y': duration / 1000.0, 'params': { 'prefix': prefix } })

    print "DURATiON: ", duration
    return {
        'chart': {
            'events': {
                'click': { 'url': '/testspecifications/' + test_run.testSpecificationName + '/report/xlt.Durations', 'params': { 'prefix': prefix } }
            }
        },
        'credits': {
            'enabled': False
        },
        'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
        'tooltip': {
            'pointFormat': '{series.name}: <b>{point.y}</b>'
        },
        'labels': {
            'enabled': False
        },
        'legend': {
            'enabled': False
        },
        'xAxis': {
            'title': None,
            'labels': {'enabled': False},
            'categories': run_times,
            'tickWidth': 0
        },
        'yAxis': {
            'labels': {
                'format': '{value} s',
            },
            'title': None,
            # 'min': 0
        },
        'plotOptions': {
            'series':  {
           } or None
        },
        'series': [{
            'data': durations,
            'name': 'duration',
            'tooltip': {
                'valueSuffix': ' s'
            },
        }]
    }


result_holder.result = {
        'flakiness': flakiness(),
        'duration': duration_trend(),
        'failures': failures_guage(),
        'description': 'This report combines a flakiness report, a durations report, and a report on the tests that failed in the latest execution of the test specification.',
        'title': 'Test health barometer'
    }
