# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

date = query_parameters['date']
range = query_parameters['range']
prefixArray = get_prefix_array(query_parameters)

events = test_runs.getEventsForTestRun(test_run, {'@tags': tags})

results = []

for event in events:
    if event.type == "functionalResult":
        result = {}
        name = ';'.join(event.hierarchy)
        url = "#/testspecifications/" + event.testSpecificationName + "/report/xlt.TestCaseOverview?testcase=" + name + "&date=" + date + "&range=" + range
        result['result'] = event.result
        result['name'] = '.'.join(event.hierarchy[:-1])
        result['testName'] = event.hierarchy[-1]
        result['url'] = url

        if event.result == "PASSED":
            result['resultImg'] = "qualification_success"
        elif event.result == "FAILED":
            result['resultImg'] = "qualification_failed"
        else:
            result['resultImg'] = "qualification_other"
            result['resultStyle'] = "fill: #999"

        results.append(result)


report = {
    'results': results,
    'description': 'This report shows detailed information about each test in the latest execution of the test specification.',
    'title': 'Detail report',
}

result_holder.result = report

