# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

prefixParam = get_prefix_param(query_parameters)
prefixArray = get_prefix_array(query_parameters)

id = test_run.id
old_test_runs = test_runs.getPreviousTestRuns(test_run, 1)

if old_test_runs:
    oldTestRun = old_test_runs.get(0)
    oldEvents = test_runs.getEventsForTestRun(oldTestRun, {})
else:
    oldTestRun = None
    oldEvents = None

events = test_runs.getEventsForTestRun(test_run, {})

rotation = -45

only_functional = lambda e: e.type == 'functionalResult'

can_drill_down_result = None

if not oldEvents:
    result_holder.result = {
            'title': "There are no old results to compare with. Please import more test results."
        }
else:
    oldEvents = filter(only_functional, oldEvents)
    events = filter(only_functional, events)

    # Figure out the new failures and passes
    events_map = {}
    if events and oldEvents:
        for ev in events:
            key = ".".join(ev.hierarchy)
            events_map[key] = ev

    oldEvents_map = {}
    if oldEvents:
        for ev in oldEvents:
            key = ".".join(ev.hierarchy)
            oldEvents_map[key] = ev

    deltaEvents = []
    for name in events_map.keys():
        if name not in oldEvents_map:
            deltaEvents.append(events_map[name])
        else:
            if events_map[name].result != oldEvents_map[name].result:
                deltaEvents.append(events_map[name])

    # Chart JSON generation
    if deltaEvents:
        passed = {}
        failed = {}
        other = {}
        for ev in deltaEvents:
            if prefix_within_hierarchy(ev, prefixArray):
                node = next_node_in_hierarchy(ev, prefixArray)
                result = ev.result

                if can_drill_down_result == None:
                    can_drill_down_result = can_drill_down(ev, prefixArray)

                if node is None:
                    continue

                if result == 'PASSED':
                    passed[node] = passed.get(node, 0) + 1
                elif result == 'OTHER':
                    other[node] = other.get(node, 0) + 1
                else:
                    failed[node] = failed.get(node, 0) + 1

        categories = sorted(set(failed.keys() + passed.keys()))

        # prevent ability to drill down over the edge
        if can_drill_down_result == False:
            prefixArray = prefixArray[:-1]

        def make_column_values(counts):
            return map(lambda t: { 'y': counts[t], 'params': { 'prefix': ';'.join(prefixArray + [t]) } } if counts.get(t, 0) > 0 else counts.get(t, 0), categories)

        passed = make_column_values(passed)
        other = make_column_values(other)
        failed = make_column_values(failed)
        #xs = map(lambda x: x[:20], xs)

        level = len(prefixArray)
        if level == 0:
            title = 'Passed versus failed tests - state changed only'
        else:
            title = 'Passed versus failed tests - state changed only at level %s' % level

        print 'Ready to render the chart', categories
        result_holder.result = {
                'chart': {
                    'type': 'column'
                },
                'title': title,
                'description': 'This report presents the tests that changed state since the previous execution.',
                'xAxis': {
                    'categories': categories,
                    'labels': {
                        'rotation': rotation,
                    }
                },
                'yAxis': {
                    'min': 0,
                    'title': {
                        'text': 'Number of tests',
                        'style': {
                            'color': '#666',
                            'font-weight': 'normal'
                        }
                    },
                    'minTickInterval': 1
                },
                'legend': {
                    'borderColor': None,
                    'symbolHeight': 16,
                    'symbolWidth': 16
                },
                'plotOptions': {
                    'column': {
                        'animation': False,
                        'cursor': 'pointer',
                        'borderRadius': 2,
                        'groupPadding': 0.1,
                        'pointPadding': 0.01
                    },
                    'series':  {
                        'point': {
                            'events': {
                                'click': 'url'
                            }
                        }
                    }
                },
                'series': [{
                    'name': 'Passed',
                    'data': passed
                }, {
                    'name': 'Failed',
                    'data': failed
                }, {
                    'name': 'Other',
                    'data': other
                }]
            }
    else:
        result_holder.result = {
                'title': "The test run is identical with the previous test run."
            }
