/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.percolate.PercolateSourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class PercolateRequest
extends BroadcastOperationRequest<PercolateRequest>
implements CompositeIndicesRequest {
    private String documentType;
    private String routing;
    private String preference;
    private GetRequest getRequest;
    private boolean onlyCount;
    private BytesReference source;
    private BytesReference docSource;
    long startTime;

    public PercolateRequest() {
    }

    PercolateRequest(PercolateRequest request, BytesReference docSource) {
        super(request);
        this.indices = request.indices();
        this.documentType = request.documentType();
        this.routing = request.routing();
        this.preference = request.preference();
        this.source = request.source;
        this.docSource = docSource;
        this.onlyCount = request.onlyCount;
        this.startTime = request.startTime;
    }

    @Override
    public List<? extends IndicesRequest> subRequests() {
        ArrayList<ActionRequest> requests = Lists.newArrayList();
        requests.add(this);
        if (this.getRequest != null) {
            requests.add(this.getRequest);
        }
        return requests;
    }

    public String documentType() {
        return this.documentType;
    }

    public PercolateRequest documentType(String type) {
        this.documentType = type;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public PercolateRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public PercolateRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public GetRequest getRequest() {
        return this.getRequest;
    }

    public PercolateRequest getRequest(GetRequest getRequest) {
        this.getRequest = getRequest;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public PercolateRequest source(Map document) throws ElasticsearchGenerationException {
        return this.source(document, Requests.CONTENT_TYPE);
    }

    public PercolateRequest source(Map document, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(document);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + document + "]", e);
        }
    }

    public PercolateRequest source(String document) {
        this.source = new BytesArray(document);
        return this;
    }

    public PercolateRequest source(XContentBuilder documentBuilder) {
        this.source = documentBuilder.bytes();
        return this;
    }

    public PercolateRequest source(byte[] document) {
        return this.source(document, 0, document.length);
    }

    public PercolateRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length));
    }

    public PercolateRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public PercolateRequest source(PercolateSourceBuilder sourceBuilder) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            sourceBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            this.source = builder.bytes();
        }
        catch (Exception e) {
            throw new SearchSourceBuilderException("Failed to build search source", e);
        }
        return this;
    }

    public boolean onlyCount() {
        return this.onlyCount;
    }

    public PercolateRequest onlyCount(boolean onlyCount) {
        this.onlyCount = onlyCount;
        return this;
    }

    BytesReference docSource() {
        return this.docSource;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.documentType == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.source == null && this.getRequest == null) {
            validationException = ValidateActions.addValidationError("source or get is missing", validationException);
        }
        if (this.getRequest != null && this.getRequest.fields() != null) {
            validationException = ValidateActions.addValidationError("get fields option isn't supported via percolate request", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.startTime = in.readVLong();
        this.documentType = in.readString();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.source = in.readBytesReference();
        this.docSource = in.readBytesReference();
        if (in.readBoolean()) {
            this.getRequest = new GetRequest(null);
            this.getRequest.readFrom(in);
        }
        this.onlyCount = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.startTime);
        out.writeString(this.documentType);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.docSource);
        if (this.getRequest != null) {
            out.writeBoolean(true);
            this.getRequest.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.onlyCount);
    }
}

