/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.smile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.elasticsearch.common.jackson.core.JsonEncoding;
import org.elasticsearch.common.jackson.core.JsonFactory;
import org.elasticsearch.common.jackson.core.JsonGenerationException;
import org.elasticsearch.common.jackson.core.JsonGenerator;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.format.InputAccessor;
import org.elasticsearch.common.jackson.core.format.MatchStrength;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.smile.PackageVersion;
import org.elasticsearch.common.jackson.dataformat.smile.SmileGenerator;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParser;
import org.elasticsearch.common.jackson.dataformat.smile.SmileParserBootstrapper;

public class SmileFactory
extends JsonFactory {
    private static final long serialVersionUID = -1696783009312472365L;
    public static final String FORMAT_NAME_SMILE = "Smile";
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser.Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator.Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures;
    protected int _smileGeneratorFeatures;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec oc) {
        super(oc);
        this._smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
        this._smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;
    }

    public SmileFactory(SmileFactory src, ObjectCodec oc) {
        super(src, oc);
        this._cfgDelegateToTextual = src._cfgDelegateToTextual;
        this._smileParserFeatures = src._smileParserFeatures;
        this._smileGeneratorFeatures = src._smileGeneratorFeatures;
    }

    @Override
    public SmileFactory copy() {
        this._checkInvalidCopy(SmileFactory.class);
        return new SmileFactory(this, null);
    }

    public void delegateToTextual(boolean state) {
        this._cfgDelegateToTextual = state;
    }

    @Override
    protected Object readResolve() {
        return new SmileFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_SMILE;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return SmileParserBootstrapper.hasSmileFormat(acc);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    public final SmileFactory configure(SmileParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public SmileFactory enable(SmileParser.Feature f) {
        this._smileParserFeatures |= f.getMask();
        return this;
    }

    public SmileFactory disable(SmileParser.Feature f) {
        this._smileParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(SmileParser.Feature f) {
        return (this._smileParserFeatures & f.getMask()) != 0;
    }

    public final SmileFactory configure(SmileGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public SmileFactory enable(SmileGenerator.Feature f) {
        this._smileGeneratorFeatures |= f.getMask();
        return this;
    }

    public SmileFactory disable(SmileGenerator.Feature f) {
        this._smileGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator.Feature f) {
        return (this._smileGeneratorFeatures & f.getMask()) != 0;
    }

    @Override
    public SmileParser createParser(File f) throws IOException {
        IOContext ctxt = this._createContext(f, true);
        return this._createParser(this._decorate(new FileInputStream(f), ctxt), ctxt);
    }

    @Override
    public SmileParser createParser(URL url) throws IOException {
        IOContext ctxt = this._createContext(url, true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(url), ctxt), ctxt);
    }

    @Override
    public SmileParser createParser(InputStream in) throws IOException {
        IOContext ctxt = this._createContext(in, false);
        return this._createParser(this._decorate(in, ctxt), ctxt);
    }

    @Override
    public SmileParser createParser(byte[] data) throws IOException {
        return this.createParser(data, 0, data.length);
    }

    @Override
    public SmileParser createParser(byte[] data, int offset, int len) throws IOException {
        InputStream in;
        IOContext ctxt = this._createContext(data, true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ctxt, data, 0, data.length)) != null) {
            return this._createParser(this._decorate(in, ctxt), ctxt);
        }
        return this._createParser(data, offset, len, ctxt);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createGenerator(this._decorate(out, ctxt), ctxt);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream out) throws IOException {
        IOContext ctxt = this._createContext(out, false);
        return this._createGenerator(this._decorate(out, ctxt), ctxt);
    }

    @Override
    protected SmileParser _createParser(InputStream in, IOContext ctxt) throws IOException {
        SmileParserBootstrapper bs = new SmileParserBootstrapper(ctxt, in);
        return bs.constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._rootByteSymbols);
    }

    @Override
    protected JsonParser _createParser(Reader r, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(r, ctxt);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected JsonParser _createParser(char[] data, int offset, int len, IOContext ctxt, boolean recyclable) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(data, offset, len, ctxt, recyclable);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected SmileParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException {
        return new SmileParserBootstrapper(ctxt, data, offset, len).constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._rootByteSymbols);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer out, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(out, ctxt);
        }
        return (JsonGenerator)this._nonByteTarget();
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream out, IOContext ctxt) throws IOException {
        return this._createGenerator(out, ctxt);
    }

    @Override
    protected Writer _createWriter(OutputStream out, JsonEncoding enc, IOContext ctxt) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(out, enc, ctxt);
        }
        return (Writer)this._nonByteTarget();
    }

    protected <T> T _nonByteSource() throws IOException {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) source");
    }

    protected <T> T _nonByteTarget() throws IOException {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) target");
    }

    protected SmileGenerator _createGenerator(OutputStream out, IOContext ctxt) throws IOException {
        int feats = this._smileGeneratorFeatures;
        SmileGenerator gen = new SmileGenerator(ctxt, this._generatorFeatures, feats, this._objectCodec, out);
        if ((feats & SmileGenerator.Feature.WRITE_HEADER.getMask()) != 0) {
            gen.writeHeader();
        } else {
            if ((feats & SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)");
            }
            if ((feats & SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)");
            }
        }
        return gen;
    }
}

