/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.traffic;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelStateEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.elasticsearch.common.netty.handler.traffic.TrafficCounter;
import org.elasticsearch.common.netty.util.ObjectSizeEstimator;
import org.elasticsearch.common.netty.util.Timeout;
import org.elasticsearch.common.netty.util.Timer;
import org.elasticsearch.common.netty.util.TimerTask;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final List<ToSend> messagesQueue = new LinkedList<ToSend>();
    private long queueSize;
    private volatile Timeout writeTimeout;
    private volatile ChannelHandlerContext ctx;

    public ChannelTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(timer, writeLimit, readLimit, checkInterval);
    }

    public ChannelTrafficShapingHandler(Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    public ChannelTrafficShapingHandler(Timer timer, long writeLimit, long readLimit) {
        super(timer, writeLimit, readLimit);
    }

    public ChannelTrafficShapingHandler(Timer timer, long checkInterval) {
        super(timer, checkInterval);
    }

    public ChannelTrafficShapingHandler(Timer timer) {
        super(timer);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit, long checkInterval, long maxTime) {
        super(objectSizeEstimator, timer, writeLimit, readLimit, checkInterval, maxTime);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long writeLimit, long readLimit) {
        super(objectSizeEstimator, timer, writeLimit, readLimit);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer, long checkInterval) {
        super(objectSizeEstimator, timer, checkInterval);
    }

    public ChannelTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Timer timer) {
        super(objectSizeEstimator, timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitWrite(final ChannelHandlerContext ctx, MessageEvent evt, long size, long delay, long now) throws Exception {
        ToSend newToSend;
        if (ctx == null) {
            this.ctx = ctx;
        }
        Channel channel = ctx.getChannel();
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (delay == 0L && this.messagesQueue.isEmpty()) {
                if (!channel.isConnected()) {
                    return;
                }
                if (this.trafficCounter != null) {
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                }
                ctx.sendDownstream(evt);
                return;
            }
            if (this.timer == null) {
                Thread.sleep(delay);
                if (!channel.isConnected()) {
                    return;
                }
                if (this.trafficCounter != null) {
                    this.trafficCounter.bytesRealWriteFlowControl(size);
                }
                ctx.sendDownstream(evt);
                return;
            }
            if (!channel.isConnected()) {
                return;
            }
            newToSend = new ToSend(delay + now, evt);
            this.messagesQueue.add(newToSend);
            this.queueSize += size;
            this.checkWriteSuspend(ctx, delay, this.queueSize);
        }
        final long futureNow = newToSend.relativeTimeAction;
        this.writeTimeout = this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                ChannelTrafficShapingHandler.this.sendAllValid(ctx, futureNow);
            }
        }, delay + 1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllValid(ChannelHandlerContext ctx, long now) throws Exception {
        Channel channel = ctx.getChannel();
        if (!channel.isConnected()) {
            return;
        }
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            while (!this.messagesQueue.isEmpty()) {
                ToSend newToSend = this.messagesQueue.remove(0);
                if (newToSend.relativeTimeAction <= now) {
                    long size = this.calculateSize(newToSend.toSend.getMessage());
                    if (this.trafficCounter != null) {
                        this.trafficCounter.bytesRealWriteFlowControl(size);
                    }
                    this.queueSize -= size;
                    if (!channel.isConnected()) break;
                    ctx.sendDownstream(newToSend.toSend);
                    continue;
                }
                this.messagesQueue.add(0, newToSend);
                break;
            }
            if (this.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(ctx);
            }
        }
    }

    public long queueSize() {
        return this.queueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            this.messagesQueue.clear();
        }
        if (this.writeTimeout != null) {
            this.writeTimeout.cancel();
        }
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.ctx = ctx;
        AbstractTrafficShapingHandler.ReadWriteStatus rws = ChannelTrafficShapingHandler.checkAttachment(ctx);
        rws.readSuspend = true;
        ctx.getChannel().setReadable(false);
        if (this.trafficCounter == null && this.timer != null) {
            this.trafficCounter = new TrafficCounter(this, this.timer, "ChannelTC" + ctx.getChannel().getId(), this.checkInterval);
        }
        if (this.trafficCounter != null) {
            this.trafficCounter.start();
        }
        rws.readSuspend = false;
        ctx.getChannel().setReadable(true);
        super.channelConnected(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExternalResources() {
        Channel channel = this.ctx.getChannel();
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (this.ctx != null && this.ctx.getChannel().isConnected()) {
                for (ToSend toSend : this.messagesQueue) {
                    if (!channel.isConnected()) break;
                    this.ctx.sendDownstream(toSend.toSend);
                }
            }
            this.messagesQueue.clear();
        }
        if (this.writeTimeout != null) {
            this.writeTimeout.cancel();
        }
        super.releaseExternalResources();
    }

    private static final class ToSend {
        final long relativeTimeAction;
        final MessageEvent toSend;

        private ToSend(long delay, MessageEvent toSend) {
            this.relativeTimeAction = delay;
            this.toSend = toSend;
        }
    }
}

