/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.percolate;

import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestPercolateAction
extends BaseRestHandler {
    @Inject
    public RestPercolateAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_percolate", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_percolate", this);
        RestPercolateExistingDocHandler existingDocHandler = new RestPercolateExistingDocHandler(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_percolate", existingDocHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_percolate", existingDocHandler);
        RestCountPercolateDocHandler countHandler = new RestCountPercolateDocHandler(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_percolate/count", countHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_percolate/count", countHandler);
        RestCountPercolateExistingDocHandler countExistingDocHandler = new RestCountPercolateExistingDocHandler(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_percolate/count", countExistingDocHandler);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_percolate/count", countExistingDocHandler);
    }

    void parseDocPercolate(PercolateRequest percolateRequest, RestRequest restRequest, RestChannel restChannel, Client client) {
        percolateRequest.indices(Strings.splitStringByCommaToArray(restRequest.param("index")));
        percolateRequest.documentType(restRequest.param("type"));
        percolateRequest.routing(restRequest.param("routing"));
        percolateRequest.preference(restRequest.param("preference"));
        percolateRequest.source(RestActions.getRestContent(restRequest));
        percolateRequest.indicesOptions(IndicesOptions.fromRequest(restRequest, percolateRequest.indicesOptions()));
        this.executePercolate(percolateRequest, restChannel, client);
    }

    void parseExistingDocPercolate(PercolateRequest percolateRequest, RestRequest restRequest, RestChannel restChannel, Client client) {
        String index = restRequest.param("index");
        String type = restRequest.param("type");
        percolateRequest.indices(Strings.splitStringByCommaToArray(restRequest.param("percolate_index", index)));
        percolateRequest.documentType(restRequest.param("percolate_type", type));
        GetRequest getRequest = new GetRequest(index, type, restRequest.param("id"));
        getRequest.routing(restRequest.param("routing"));
        getRequest.preference(restRequest.param("preference"));
        getRequest.refresh(restRequest.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.realtime(restRequest.paramAsBoolean("realtime", null));
        getRequest.version(RestActions.parseVersion(restRequest));
        getRequest.versionType(VersionType.fromString(restRequest.param("version_type"), getRequest.versionType()));
        percolateRequest.getRequest(getRequest);
        percolateRequest.routing(restRequest.param("percolate_routing"));
        percolateRequest.preference(restRequest.param("percolate_preference"));
        percolateRequest.source(RestActions.getRestContent(restRequest));
        percolateRequest.indicesOptions(IndicesOptions.fromRequest(restRequest, percolateRequest.indicesOptions()));
        this.executePercolate(percolateRequest, restChannel, client);
    }

    void executePercolate(PercolateRequest percolateRequest, RestChannel restChannel, Client client) {
        percolateRequest.listenerThreaded(false);
        client.percolate(percolateRequest, new RestToXContentListener<PercolateResponse>(restChannel));
    }

    @Override
    public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) {
        PercolateRequest percolateRequest = new PercolateRequest();
        this.parseDocPercolate(percolateRequest, restRequest, restChannel, client);
    }

    final class RestCountPercolateExistingDocHandler
    extends BaseRestHandler {
        protected RestCountPercolateExistingDocHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) {
            PercolateRequest percolateRequest = new PercolateRequest();
            percolateRequest.onlyCount(true);
            RestPercolateAction.this.parseExistingDocPercolate(percolateRequest, restRequest, restChannel, client);
        }
    }

    final class RestPercolateExistingDocHandler
    extends BaseRestHandler {
        protected RestPercolateExistingDocHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) {
            PercolateRequest percolateRequest = new PercolateRequest();
            RestPercolateAction.this.parseExistingDocPercolate(percolateRequest, restRequest, restChannel, client);
        }
    }

    final class RestCountPercolateDocHandler
    extends BaseRestHandler {
        private RestCountPercolateDocHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        public void handleRequest(RestRequest restRequest, RestChannel restChannel, Client client) {
            PercolateRequest percolateRequest = new PercolateRequest();
            percolateRequest.onlyCount(true);
            RestPercolateAction.this.parseDocPercolate(percolateRequest, restRequest, restChannel, client);
        }
    }
}

