/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Verifications {
    private List<String> verifications = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(LocalBooter.class);

    Verifications() {
    }

    void verify(Type t, boolean condition, String messageTemplate, Object ... parameters) {
        if (!condition) {
            this.verifications.add(t + ": " + String.format(messageTemplate, parameters));
        }
    }

    void verify(boolean condition, String messageTemplate, Object ... parameters) {
        if (!condition) {
            this.verifications.add(String.format(messageTemplate, parameters));
        }
    }

    void done() {
        if (!this.verifications.isEmpty()) {
            logger.error("Verifications failed:");
            for (String s : this.verifications) {
                logger.error(s);
            }
            throw new IllegalStateException("There is an error in the defined types: \n" + Joiner.on((String)"\n").join(this.verifications));
        }
    }
}

