/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrConstants;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.LicenseRepositoryIdException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u0017\ta\"j\u0019:SKB|7/\u001b;peflU\r^1eCR\f7+\u001a:wS\u000e,'BA\u0002\u0005\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u000b\u0019\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u0019QY\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UIR\"\u0001\f\u000b\u0005\r9\"B\u0001\r\u0007\u0003!!W\r\u001d7ps&$\u0018B\u0001\u000e\u0017\u0005e\u0011V\r]8tSR|'/_'fi\u0006$\u0017\r^1TKJ4\u0018nY3\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012!B:mMRR'\"\u0001\u0011\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AI\u000f\u0003\u000f1{wmZ5oO\"AA\u0005\u0001B\u0001B\u0003%Q%A\u0006kGJ$V-\u001c9mCR,\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0018\u0003\rQ7M]\u0005\u0003U\u001d\u00121BS2s)\u0016l\u0007\u000f\\1uK\")A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"\"A\f\u0019\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000b\u0011Z\u0003\u0019A\u0013\t\u000fI\u0002\u0001\u0019!C\u0005g\u0005a1\u000f^8sK\u0012\u0014V\r]8JIV\tA\u0007E\u00026qij\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005mrdBA\u001b=\u0013\tid'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f7\u0011\u001d\u0011\u0005\u00011A\u0005\n\r\u000b\u0001c\u001d;pe\u0016$'+\u001a9p\u0013\u0012|F%Z9\u0015\u0005\u0011;\u0005CA\u001bF\u0013\t1eG\u0001\u0003V]&$\bb\u0002%B\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0004B\u0002&\u0001A\u0003&A'A\u0007ti>\u0014X\r\u001a*fa>LE\r\t\u0005\u0006\u0019\u0002!\t%T\u0001\u001dm\u0006d\u0017\u000eZ1uK\u0006sGm\u0015;pe\u0016\u0014V\r]8tSR|'/_%e)\t!e\nC\u0003P\u0017\u0002\u0007!(\u0001\u0007sKB|7/\u001b;pefLE\rC\u0003R\u0001\u0011\u0005!+\u0001\ttCZ,'+\u001a9pg&$xN]=JIR\u0011Ai\u0015\u0005\u0006\u001fB\u0003\rA\u000f\u0005\u0006+\u0002!IaM\u0001\u0010O\u0016$(+\u001a9pg&$xN]=JI\")q\u000b\u0001C\u0005g\u0005\t\u0012/^3ssJ+\u0007o\\:ji>\u0014\u00180\u00133")
public class JcrRepositoryMetadataService
implements RepositoryMetadataService,
Logging {
    private final JcrTemplate jcrTemplate;
    private Option<String> storedRepoId;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JcrRepositoryMetadataService jcrRepositoryMetadataService = this;
        synchronized (jcrRepositoryMetadataService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger : this.grizzled$slf4j$Logging$$_logger$lzycompute();
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    private Option<String> storedRepoId() {
        return this.storedRepoId;
    }

    private void storedRepoId_$eq(Option<String> x$1) {
        this.storedRepoId = x$1;
    }

    public void validateAndStoreRepositoryId(String repositoryId) {
        Option<String> option;
        block5: {
            block4: {
                block2: {
                    String current;
                    block3: {
                        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)repositoryId) ? 1 : 0) != 0);
                        option = this.getRepositoryId();
                        if (!(option instanceof Some)) break block2;
                        Some some = (Some)option;
                        String string = current = (String)some.x();
                        String string2 = repositoryId;
                        if (string != null ? !string.equals(string2) : string2 != null) break block3;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    throw new LicenseRepositoryIdException(current, repositoryId);
                }
                if (!None$.MODULE$.equals(option)) break block5;
                this.saveRepositoryId(repositoryId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public void saveRepositoryId(String repositoryId) {
        this.jcrTemplate.execute(new JcrCallback<String>(this, repositoryId){
            private final String repositoryId$1;

            public String doInJcr(Session session) {
                Node configurationNode = session.getNode(JcrConstants.CONFIGURATION_NODE_ID);
                Property property = configurationNode.setProperty(JcrConstants.REPOSITORY_ID_PROPERTY_NAME, this.repositoryId$1);
                session.save();
                return property.getString();
            }
            {
                this.repositoryId$1 = repositoryId$1;
            }
        });
    }

    private Option<String> getRepositoryId() {
        Option<String> option;
        block4: {
            block3: {
                block2: {
                    option = this.storedRepoId();
                    if (!(option instanceof Some)) break block2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.storedRepoId_$eq(this.queryRepositoryId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return this.storedRepoId();
        }
        throw new MatchError(option);
    }

    private Option<String> queryRepositoryId() {
        return this.jcrTemplate.execute(new JcrCallback<Option<String>>(this){

            public Option<String> doInJcr(Session session) {
                Node configurationNode = session.getNode(JcrConstants.CONFIGURATION_NODE_ID);
                return configurationNode.hasProperty(JcrConstants.REPOSITORY_ID_PROPERTY_NAME) ? new Some((Object)configurationNode.getProperty(JcrConstants.REPOSITORY_ID_PROPERTY_NAME).getString()) : None$.MODULE$;
            }
        });
    }

    public JcrRepositoryMetadataService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
        Logging.class.$init$((Logging)this);
        this.storedRepoId = None$.MODULE$;
    }
}

