/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.CouldNotParseFitFailureException;
import fit.exception.FitFailureException;
import fit.exception.NoSuchMethodFitFailureException;
import java.lang.reflect.Method;

public class ActionFixture
extends Fixture {
    protected static final Class<?>[] empty = new Class[0];
    protected Parse cells;
    private Fixture actor;

    @Override
    public void doCells(Parse cells) {
        this.cells = cells;
        try {
            Method action = this.getClass().getMethod(cells.text(), empty);
            action.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.exception(cells, e);
        }
    }

    public void start() throws Throwable {
        Parse fixture = this.cells.more;
        if (fixture == null) {
            throw new FitFailureException("You must specify a fixture to start.");
        }
        this.actor = ActionFixture.loadFixture(fixture.text());
    }

    public Fixture getActor() {
        return this.actor;
    }

    public void enter() throws Exception {
        Object[] args;
        Method method = this.method(1);
        Class<?> type = method.getParameterTypes()[0];
        Parse argumentCell = this.cells.more.more;
        if (argumentCell == null) {
            throw new FitFailureException("You must specify an argument.");
        }
        String text = argumentCell.text();
        try {
            args = new Object[]{TypeAdapter.on(this.actor, type).parse(text)};
        }
        catch (NumberFormatException e) {
            throw new CouldNotParseFitFailureException(text, type.getName());
        }
        method.invoke((Object)this.actor, args);
    }

    public void press() throws Exception {
        this.method(0).invoke((Object)this.actor, new Object[0]);
    }

    public void check() throws Throwable {
        TypeAdapter adapter;
        Method theMethod = this.method(0);
        Class<?> type = theMethod.getReturnType();
        try {
            adapter = TypeAdapter.on(this.actor, theMethod);
        }
        catch (Throwable e) {
            throw new FitFailureException("Can not parse return type: " + type.getName());
        }
        Parse checkValueCell = this.cells.more.more;
        if (checkValueCell == null) {
            throw new FitFailureException("You must specify a value to check.");
        }
        this.check(checkValueCell, adapter);
    }

    protected Method method(int args) throws NoSuchMethodException {
        Parse methodCell = this.cells.more;
        if (methodCell == null) {
            throw new FitFailureException("You must specify a method.");
        }
        return this.method(ActionFixture.camel(methodCell.text()), args);
    }

    protected Method method(String test, int args) throws NoSuchMethodException {
        if (this.actor == null) {
            throw new FitFailureException("You must start a fixture using the 'start' keyword.");
        }
        Method[] methods = this.actor.getClass().getMethods();
        Method result = null;
        for (Method m : methods) {
            if (!m.getName().equals(test) || m.getParameterTypes().length != args) continue;
            if (result == null) {
                result = m;
                continue;
            }
            throw new FitFailureException("You can only have one " + test + "(arg) method in your fixture.");
        }
        if (result == null) {
            throw new NoSuchMethodFitFailureException(test);
        }
        return result;
    }
}

