/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class PluginsClassLoader {
    private File pluginsDirectory;

    public PluginsClassLoader(String rootPath) {
        this.pluginsDirectory = new File(rootPath, "plugins");
    }

    public void addPluginsToClassLoader() throws Exception {
        if (this.pluginsDirectory.exists()) {
            for (File plugin : this.pluginsDirectory.listFiles()) {
                if (!plugin.getName().endsWith("jar")) continue;
                PluginsClassLoader.addItemsToClasspath(plugin.getCanonicalPath());
            }
        }
    }

    public static void addItemsToClasspath(String classpathItems) throws Exception {
        String[] items;
        String separator = File.pathSeparator;
        String currentClassPath = System.getProperty("java.class.path");
        System.setProperty("java.class.path", currentClassPath + separator + classpathItems);
        for (String item : items = classpathItems.split(separator)) {
            PluginsClassLoader.addFileToClassPath(item);
        }
    }

    private static void addFileToClassPath(String fileName) throws Exception {
        PluginsClassLoader.addUrlToClasspath(new File(fileName).toURI().toURL());
    }

    public static void addUrlToClasspath(URL u) throws Exception {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysClass = URLClassLoader.class;
        Method method = sysClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysLoader, u);
    }
}

