/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MockResponseSender
implements ResponseSender {
    private final OutputStream output;
    protected boolean closed;

    public MockResponseSender() {
        this(new ByteArrayOutputStream());
    }

    public MockResponseSender(OutputStream output) {
        this.output = output;
    }

    @Override
    public void send(byte[] bytes) {
        try {
            this.output.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String sentData() {
        try {
            return ((ByteArrayOutputStream)this.output).toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to decode output stream", e);
        }
    }

    public void doSending(Response response) throws IOException {
        response.sendTo(this);
        assert (this.closed);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

