/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.reporting.history.PageHistoryReader;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.testsystems.ExecutionResult;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PageHistory
extends PageHistoryReader {
    public static final String TEST_RESULT_FILE_DATE_PATTERN = "yyyyMMddHHmmss";
    private int failures = 0;
    private int passes = 0;
    private Date minDate = null;
    private Date maxDate = null;
    private int maxAssertions = 0;
    private BarGraph barGraph;
    private String fullPageName;
    private final Map<Date, TestResultRecord> testResultMap = new HashMap<Date, TestResultRecord>();
    private Map<Date, File> pageFiles = new HashMap<Date, File>();

    public PageHistory(File pageDirectory) {
        this.fullPageName = pageDirectory.getName();
        try {
            this.readHistoryFromPageDirectory(pageDirectory);
            this.compileBarGraph();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compileBarGraph() {
        ArrayList<Date> dates = new ArrayList<Date>(this.testResultMap.keySet());
        Collections.sort(dates, this.reverseChronologicalDateComparator());
        this.barGraph = new BarGraph();
        for (int i = 0; i < dates.size() && i < 20; ++i) {
            Date date = (Date)dates.get(i);
            this.barGraph.addSummary(date, this.get(date));
        }
    }

    private Comparator<Date> reverseChronologicalDateComparator() {
        return new Comparator<Date>(){

            @Override
            public int compare(Date d1, Date d2) {
                long diff = d2.getTime() - d1.getTime();
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        };
    }

    @Override
    void processTestFile(TestResultRecord record) throws ParseException {
        Date date = record.getDate();
        this.addTestResult(record, date);
        this.countResult(record);
        this.setMinMaxDate(date);
        this.setMaxAssertions(record);
        this.pageFiles.put(date, record.getFile());
    }

    private void addTestResult(TestResultRecord record, Date date) {
        this.testResultMap.put(date, record);
    }

    private Date trimMilliseconds(Date date) {
        long milliseconds = date.getTime();
        long seconds = milliseconds / 1000L;
        return new Date(seconds * 1000L);
    }

    public String getPageFileName(Date date) {
        if (this.pageFiles.get(date) != null) {
            return this.pageFiles.get(date).getName();
        }
        return null;
    }

    private void setMaxAssertions(TestResultRecord summary) {
        int assertions = summary.getRight() + summary.getWrong() + summary.getExceptions();
        this.maxAssertions = Math.max(this.maxAssertions, assertions);
    }

    private void setMinMaxDate(Date date) {
        if (this.minDate == null) {
            this.minDate = this.maxDate = date;
        } else if (date.getTime() > this.maxDate.getTime()) {
            this.maxDate = date;
        } else if (date.getTime() < this.minDate.getTime()) {
            this.minDate = date;
        }
    }

    private void countResult(TestResultRecord summary) {
        ExecutionResult result = ExecutionResult.getExecutionResult(summary.getWikiPageName(), summary.toTestSummary());
        if (result == ExecutionResult.FAIL || result == ExecutionResult.ERROR) {
            ++this.failures;
        } else {
            ++this.passes;
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getPasses() {
        return this.passes;
    }

    public Date getMinDate() {
        return new Date(this.minDate.getTime());
    }

    public Date getMaxDate() {
        return new Date(this.maxDate.getTime());
    }

    public BarGraph getBarGraph() {
        return this.barGraph;
    }

    public int size() {
        return this.testResultMap.size();
    }

    public TestResultRecord get(Date key) {
        return this.testResultMap.get(this.trimMilliseconds(key));
    }

    public int maxAssertions() {
        return this.maxAssertions;
    }

    public SortedSet<Date> datesInChronologicalOrder() {
        Set<Date> dates = this.testResultMap.keySet();
        TreeSet<Date> sortedDates = new TreeSet<Date>(Collections.reverseOrder());
        sortedDates.addAll(dates);
        return sortedDates;
    }

    public PassFailBar getPassFailBar(Date date, int maxUnits) {
        TestResultRecord summary = this.get(date);
        int fail = summary.getWrong() + summary.getExceptions();
        double unitsPerAssertion = (double)maxUnits / (double)this.maxAssertions;
        int unitsForThisTest = (int)Math.round((double)(fail + summary.getRight()) * unitsPerAssertion);
        double doubleFailUnits = (double)fail * unitsPerAssertion;
        int failUnits = (int)doubleFailUnits;
        if (Math.abs(doubleFailUnits - (double)failUnits) > 0.001) {
            ++failUnits;
        }
        int passUnits = unitsForThisTest - failUnits;
        return new PassFailBar(summary.getRight(), fail, passUnits, failUnits);
    }

    public String getFullPageName() {
        return this.fullPageName;
    }

    public Date getLatestDate() {
        Set<Date> dateSet = this.testResultMap.keySet();
        ArrayList<Date> dates = new ArrayList<Date>(dateSet);
        Collections.sort(dates);
        return (Date)dates.get(dates.size() - 1);
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(format, Locale.US);
        return fmt.format(date);
    }

    public class PassFailBar {
        private int passUnits;
        private int failUnits;
        private int pass;
        private int fail;

        public PassFailBar(int pass, int fail, int passUnits, int failUnits) {
            this.pass = pass;
            this.fail = fail;
            this.passUnits = passUnits;
            this.failUnits = failUnits;
        }

        public int getPassUnits() {
            return this.passUnits;
        }

        public int getFailUnits() {
            return this.failUnits;
        }

        public int getPass() {
            return this.pass;
        }

        public int getFail() {
            return this.fail;
        }
    }

    public static class BarGraph {
        private Date startingDate;
        private Date endingDate;
        private List<PassFailReport> passFailList = new ArrayList<PassFailReport>();

        public Date getStartingDate() {
            return new Date(this.startingDate.getTime());
        }

        public String formatStartingDate(String format) {
            return PageHistory.formatDate(format, this.startingDate);
        }

        public String formatEndingDate(String format) {
            return PageHistory.formatDate(format, this.endingDate);
        }

        public Date getEndingDate() {
            return new Date(this.endingDate.getTime());
        }

        public void addSummary(Date date, TestResultRecord summary) {
            this.minMaxDate(summary);
            ExecutionResult result = ExecutionResult.getExecutionResult(summary.getWikiPageName(), summary.toTestSummary());
            this.passFailList.add(new PassFailReport(date, result));
        }

        private void minMaxDate(TestResultRecord summary) {
            Date date = summary.getDate();
            if (this.startingDate == null) {
                this.startingDate = this.endingDate = date;
            } else if (date.getTime() < this.startingDate.getTime()) {
                this.startingDate = date;
            } else if (date.getTime() > this.endingDate.getTime()) {
                this.endingDate = date;
            }
        }

        public int size() {
            return this.passFailList.size();
        }

        public PassFailReport getPassFail(int i) {
            return this.passFailList.get(i);
        }

        public PassFailReport[] passFailArray() {
            return this.passFailList.toArray(new PassFailReport[this.passFailList.size()]);
        }

        public String testString() {
            StringBuilder builder = new StringBuilder();
            for (PassFailReport report : this.passFailList) {
                builder.append(report.isPass() ? "+" : "-");
            }
            return builder.toString();
        }
    }

    public static class PassFailReport {
        private String date;
        private ExecutionResult result;

        public PassFailReport(Date date, ExecutionResult result) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(PageHistory.TEST_RESULT_FILE_DATE_PATTERN);
            this.date = dateFormat.format(date);
            this.result = result;
        }

        public String getDate() {
            return this.date;
        }

        public ExecutionResult getResult() {
            return this.result;
        }

        public boolean isPass() {
            return this.result == ExecutionResult.PASS;
        }
    }
}

