/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableStore {
    private Map<String, MethodExecutionResult> variables = new HashMap<String, MethodExecutionResult>();

    public void setSymbol(String name, MethodExecutionResult value) {
        this.variables.put(name, value);
    }

    public MethodExecutionResult getSymbol(String name) {
        return this.variables.get(name);
    }

    public Object getStored(String nameWithDollar) {
        if (nameWithDollar == null || !nameWithDollar.startsWith("$")) {
            return null;
        }
        String name = nameWithDollar.substring(1);
        if (!this.variables.containsKey(name)) {
            return null;
        }
        return this.variables.get(name).getObject();
    }

    private boolean containsValueFor(String nameWithDollar) {
        return nameWithDollar != null && nameWithDollar.startsWith("$") && this.variables.containsKey(nameWithDollar.substring(1));
    }

    public Object[] replaceSymbols(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.replaceSymbol(args[i]);
        }
        return result;
    }

    private List<Object> replaceSymbolsInList(List<Object> objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : objects) {
            result.add(this.replaceSymbol(object));
        }
        return result;
    }

    private Object replaceSymbol(Object object) {
        if (object instanceof List) {
            return this.replaceSymbolsInList((List)object);
        }
        if (this.containsValueFor((String)object)) {
            return this.getStored((String)object);
        }
        return this.replaceSymbolsInString((String)object);
    }

    public String replaceSymbolsInString(String arg) {
        if (SlimSymbol.isSymbolAssignment(arg) != null) {
            return "";
        }
        return new SlimSymbol(){

            @Override
            protected String getSymbolValue(String symbolName) {
                return VariableStore.this.getStoreSymbolValue(symbolName);
            }
        }.replace(arg);
    }

    private String getStoreSymbolValue(String symbolName) {
        if (this.variables.containsKey(symbolName)) {
            String replacement = "null";
            MethodExecutionResult value = this.variables.get(symbolName);
            if (value != null) {
                replacement = ((Object)value).toString();
            }
            return replacement;
        }
        return null;
    }
}

