/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.QueryTable;
import java.util.List;

public class OrderedQueryTable
extends QueryTable {
    private int lastMatchedRow = -1;

    public OrderedQueryTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    @Override
    protected ExecutionResult markRows(QueryTable.QueryResults queryResults, Iterable<QueryTable.MatchedResult> potentialMatchesByScore) {
        int rowCount = this.table.getRowCount();
        List<Integer> unmatchedResultRows = this.unmatchedRows(queryResults.getRows().size());
        for (int tableRow = 2; tableRow < rowCount; ++tableRow) {
            QueryTable.MatchedResult bestMatch = this.takeBestMatch(potentialMatchesByScore, tableRow);
            if (bestMatch == null) {
                this.markMissingRow(tableRow);
                continue;
            }
            this.markFieldsInMatchedRow(bestMatch.tableRow, bestMatch.resultRow, queryResults);
            this.lastMatchedRow = bestMatch.resultRow;
            unmatchedResultRows.remove(bestMatch.resultRow);
        }
        this.markSurplusRows(queryResults, unmatchedResultRows);
        return !unmatchedResultRows.isEmpty() ? ExecutionResult.FAIL : ExecutionResult.PASS;
    }

    private QueryTable.MatchedResult takeBestMatch(Iterable<QueryTable.MatchedResult> potentialMatchesByScore, int tableRow) {
        for (QueryTable.MatchedResult bestResult : potentialMatchesByScore) {
            if (bestResult.tableRow != tableRow) continue;
            this.removeOtherwiseMatchedResults(potentialMatchesByScore, bestResult);
            return bestResult;
        }
        return null;
    }

    @Override
    protected SlimTestResult markMatch(int tableRow, int matchedRow, int col, String message) {
        SlimTestResult testResult = col == 0 && matchedRow <= this.lastMatchedRow ? SlimTestResult.fail(null, message, "out of order: row " + (matchedRow + 1)) : SlimTestResult.pass(message);
        return testResult;
    }
}

