/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.util.List;

public class Help
extends SymbolType
implements Rule,
Translation {
    private static final String editableOption = "-editable";

    public Help() {
        super("Help");
        this.wikiMatcher(new Matcher().string("!help"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        String option;
        List<Symbol> lookAhead = parser.peek(new SymbolType[]{SymbolType.Whitespace, SymbolType.Text});
        if (!lookAhead.isEmpty() && (option = lookAhead.get(1).getContent()).equals(editableOption)) {
            current.putProperty(editableOption, "");
            parser.moveNext(2);
        }
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        String editText;
        String helpText = translator.getPage().getProperty("Help");
        String string = editText = helpText.isEmpty() ? "edit help text" : "edit";
        if (symbol.hasProperty(editableOption)) {
            helpText = helpText + " <a href=\"" + translator.getPage().getFullPath() + "?properties\">(" + editText + ")</a>";
        }
        return helpText;
    }
}

