/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.mixed;

import java.util.concurrent.Executor;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.jdbc.binary.JdbcBinaryStore;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.mixed.InitialisationContextDelegate;
import org.infinispan.persistence.jdbc.stringbased.JdbcStringBasedStore;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=JdbcMixedStoreConfiguration.class)
public class JdbcMixedStore
implements AdvancedLoadWriteStore {
    private static final Log log = LogFactory.getLog(JdbcMixedStore.class);
    private JdbcMixedStoreConfiguration configuration;
    private JdbcBinaryStore binaryStore = new JdbcBinaryStore();
    private JdbcStringBasedStore stringStore = new JdbcStringBasedStore();
    private ConnectionFactory sharedConnectionFactory;

    public void init(InitializationContext ctx) {
        this.configuration = (JdbcMixedStoreConfiguration)ctx.getConfiguration();
        this.binaryStore.init(new InitialisationContextDelegate(ctx, (StoreConfiguration)this.buildBinaryStoreConfiguration(this.configuration)));
        this.stringStore.init(new InitialisationContextDelegate(ctx, (StoreConfiguration)this.buildStringStoreConfiguration(this.configuration)));
    }

    public void start() {
        ConnectionFactoryConfiguration factoryConfig = this.configuration.connectionFactory();
        this.sharedConnectionFactory = ConnectionFactory.getConnectionFactory(factoryConfig.connectionFactoryClass().getName(), ((Object)((Object)this.configuration)).getClass().getClassLoader());
        this.sharedConnectionFactory.start(factoryConfig, ((Object)((Object)this.configuration)).getClass().getClassLoader());
        this.binaryStore.doConnectionFactoryInitialization(this.sharedConnectionFactory);
        this.binaryStore.start();
        this.stringStore.initializeConnectionFactory(this.sharedConnectionFactory);
        this.stringStore.start();
    }

    public void stop() {
        Throwable cause = null;
        try {
            this.binaryStore.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug((Object)"Exception while stopping", t);
        }
        try {
            this.stringStore.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug((Object)"Exception while stopping", t);
        }
        try {
            this.sharedConnectionFactory.stop();
        }
        catch (Throwable t) {
            if (cause == null) {
                cause = t;
            }
            log.debug((Object)"Exception while stopping", t);
        }
        if (cause != null) {
            throw new PersistenceException("Exceptions occurred while stopping store", cause);
        }
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener task) {
        this.binaryStore.purge(threadPool, task);
        this.stringStore.purge(threadPool, task);
    }

    public MarshalledEntry load(Object key) {
        return this.getStore(key).load(key);
    }

    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        this.binaryStore.process(filter, task, executor, fetchValue, fetchMetadata);
        this.stringStore.process(filter, task, executor, fetchValue, fetchMetadata);
    }

    public void write(MarshalledEntry ed) {
        this.getStore(ed.getKey()).write(ed);
    }

    public boolean delete(Object key) {
        return this.getStore(key).delete(key);
    }

    public int size() {
        return this.stringStore.size() + this.binaryStore.size();
    }

    public boolean contains(Object key) {
        return this.getStore(key).contains(key);
    }

    public void clear() {
        this.binaryStore.clear();
        this.stringStore.clear();
    }

    public ConnectionFactory getConnectionFactory() {
        return this.sharedConnectionFactory;
    }

    public JdbcBinaryStore getBinaryStore() {
        return this.binaryStore;
    }

    public JdbcStringBasedStore getStringStore() {
        return this.stringStore;
    }

    private JdbcStringBasedStoreConfiguration buildStringStoreConfiguration(JdbcMixedStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcStringBasedStoreConfigurationBuilder stringBuilder = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        stringBuilder.key2StringMapper(configuration.key2StringMapper()).table().read(configuration.stringTable());
        return stringBuilder.create();
    }

    private JdbcBinaryStoreConfiguration buildBinaryStoreConfiguration(JdbcMixedStoreConfiguration configuration) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        JdbcBinaryStoreConfigurationBuilder binaryBuilder = (JdbcBinaryStoreConfigurationBuilder)((JdbcBinaryStoreConfigurationBuilder)builder.persistence().addStore(JdbcBinaryStoreConfigurationBuilder.class)).manageConnectionFactory(false);
        binaryBuilder.table().read(configuration.binaryTable());
        return binaryBuilder.create();
    }

    private AdvancedLoadWriteStore getStore(Object key) {
        return this.stringStore.supportsKey(key.getClass()) ? this.stringStore : this.binaryStore;
    }

    public JdbcMixedStoreConfiguration getConfiguration() {
        return this.configuration;
    }
}

