/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.concurrent;

import org.python.netty.util.concurrent.Future;
import org.python.netty.util.concurrent.GenericFutureListener;
import org.python.netty.util.concurrent.Promise;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private final Promise<? super V>[] promises;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promises) {
        if (promises == null) {
            throw new NullPointerException("promises");
        }
        for (Promise<? super V> promise : promises) {
            if (promise != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promises.clone();
    }

    @Override
    public void operationComplete(F future2) throws Exception {
        if (future2.isSuccess()) {
            Object result2 = future2.get();
            for (Promise promise : this.promises) {
                promise.setSuccess(result2);
            }
            return;
        }
        Throwable cause = future2.cause();
        for (Promise<V> promise : this.promises) {
            promise.setFailure(cause);
        }
    }
}

