/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.WriteableCommandLine;
import org.apache.commons.cli2.option.ParentImpl;

public class DefaultOption
extends ParentImpl {
    public static final String DEFAULT_SHORT_PREFIX = "-";
    public static final String DEFAULT_LONG_PREFIX = "--";
    public static final boolean DEFAULT_BURST_ENABLED = true;
    private final String preferredName;
    private final Set aliases;
    private final Set burstAliases;
    private final Set triggers;
    private final Set prefixes;
    private final String shortPrefix;
    private final boolean burstEnabled;
    private final int burstLength;

    public DefaultOption(String shortPrefix, String longPrefix, boolean burstEnabled, String preferredName, String description, Set aliases, Set burstAliases, boolean required, Argument argument, Group children, int id) {
        super(argument, children, description, id, required);
        this.shortPrefix = shortPrefix;
        this.burstEnabled = burstEnabled;
        this.burstLength = shortPrefix.length() + 1;
        this.preferredName = preferredName;
        this.aliases = aliases == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(aliases));
        this.burstAliases = burstAliases == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(burstAliases));
        HashSet<String> newTriggers = new HashSet<String>();
        newTriggers.add(preferredName);
        newTriggers.addAll(this.aliases);
        newTriggers.addAll(this.burstAliases);
        this.triggers = Collections.unmodifiableSet(newTriggers);
        HashSet<String> newPrefixes = new HashSet<String>(super.getPrefixes());
        newPrefixes.add(shortPrefix);
        newPrefixes.add(longPrefix);
        this.prefixes = Collections.unmodifiableSet(newPrefixes);
        this.checkPrefixes(newPrefixes);
    }

    public boolean canProcess(WriteableCommandLine commandLine, String argument) {
        return argument != null && (super.canProcess(commandLine, argument) || argument.length() >= this.burstLength && this.burstAliases.contains(argument.substring(0, this.burstLength)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processParent(WriteableCommandLine commandLine, ListIterator arguments) throws OptionException {
        String argument = (String)arguments.next();
        if (this.triggers.contains(argument)) {
            commandLine.addOption(this);
            arguments.set(this.preferredName);
            return;
        } else {
            if (!this.burstEnabled || argument.length() < this.burstLength) throw new OptionException(this, "Unexpected.token", argument);
            String burst = argument.substring(0, this.burstLength);
            if (!this.burstAliases.contains(burst)) throw new OptionException(this, "Cannot.burst", argument);
            commandLine.addOption(this);
            arguments.set(this.preferredName);
            if (this.getArgument() == null) {
                arguments.add(String.valueOf(this.shortPrefix) + argument.substring(this.burstLength));
            } else {
                arguments.add(argument.substring(this.burstLength));
            }
            arguments.previous();
        }
    }

    public Set getTriggers() {
        return this.triggers;
    }

    public Set getPrefixes() {
        return this.prefixes;
    }

    public void validate(WriteableCommandLine commandLine) throws OptionException {
        if (this.isRequired() && !commandLine.hasOption(this)) {
            throw new OptionException(this, "Option.missing.required", this.getPreferredName());
        }
        super.validate(commandLine);
    }

    public void appendUsage(StringBuffer buffer, Set helpSettings, Comparator comp) {
        boolean optional = !this.isRequired() && helpSettings.contains(DisplaySetting.DISPLAY_OPTIONAL);
        boolean displayAliases = helpSettings.contains(DisplaySetting.DISPLAY_ALIASES);
        if (optional) {
            buffer.append('[');
        }
        buffer.append(this.preferredName);
        if (displayAliases && !this.aliases.isEmpty()) {
            buffer.append(" (");
            ArrayList list = new ArrayList(this.aliases);
            Collections.sort(list);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String alias = (String)i.next();
                buffer.append(alias);
                if (!i.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
        }
        super.appendUsage(buffer, helpSettings, comp);
        if (optional) {
            buffer.append(']');
        }
    }

    public String getPreferredName() {
        return this.preferredName;
    }
}

