/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.resource;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceHelper {
    private static final String PROP_LOCALE = "org.apache.commons.cli2.resource.bundle";
    private static final String DEFAULT_BUNDLE = "org.apache.commons.cli2.resource.CLIMessageBundle_en_US";
    private static ResourceHelper helper;
    private ResourceBundle bundle;
    private String prop;

    private ResourceHelper() {
        Locale locale;
        String bundleName = System.getProperty(PROP_LOCALE);
        if (bundleName == null) {
            bundleName = DEFAULT_BUNDLE;
        }
        this.prop = bundleName;
        int firstUnderscore = bundleName.indexOf(95);
        int secondUnderscore = bundleName.indexOf(95, firstUnderscore + 1);
        if (firstUnderscore != -1) {
            String language = bundleName.substring(firstUnderscore + 1, secondUnderscore);
            String country = bundleName.substring(secondUnderscore + 1);
            locale = new Locale(language, country);
        } else {
            locale = Locale.getDefault();
        }
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException exp) {
            this.bundle = ResourceBundle.getBundle(DEFAULT_BUNDLE, locale);
        }
    }

    public String getBundleName() {
        return this.prop;
    }

    public static ResourceHelper getResourceHelper() {
        String bundleName = System.getProperty(PROP_LOCALE);
        if (helper == null || !helper.getBundleName().equals(bundleName)) {
            helper = new ResourceHelper();
        }
        return helper;
    }

    public String getMessage(String key) {
        return this.getMessage(key, new Object[0]);
    }

    public String getMessage(String key, Object value) {
        return this.getMessage(key, new Object[]{value});
    }

    public String getMessage(String key, Object value1, Object value2) {
        return this.getMessage(key, new Object[]{value1, value2});
    }

    public String getMessage(String key, Object value1, Object value2, Object value3) {
        return this.getMessage(key, new Object[]{value1, value2, value3});
    }

    public String getMessage(String key, Object[] values) {
        String msgFormatStr = this.bundle.getString(key);
        MessageFormat msgFormat = new MessageFormat(msgFormatStr);
        return msgFormat.format(values);
    }
}

