/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.util;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.Command;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.Switch;

public class Comparators {
    private Comparators() {
    }

    public static Comparator chain(Comparator c0, Comparator c1) {
        return Comparators.chain(new Comparator[]{c0, c1});
    }

    public static Comparator chain(Comparator c0, Comparator c1, Comparator c2) {
        return Comparators.chain(new Comparator[]{c0, c1, c2});
    }

    public static Comparator chain(Comparator c0, Comparator c1, Comparator c2, Comparator c3) {
        return Comparators.chain(new Comparator[]{c0, c1, c2, c3});
    }

    public static Comparator chain(Comparator c0, Comparator c1, Comparator c2, Comparator c3, Comparator c4) {
        return Comparators.chain(new Comparator[]{c0, c1, c2, c3, c4});
    }

    public static Comparator chain(List comparators) {
        return new Chain(comparators.toArray(new Comparator[comparators.size()]));
    }

    public static Comparator chain(Comparator[] comparators) {
        return new Chain(comparators);
    }

    private static Comparator reverse(Comparator wrapped) {
        return new Reverse(wrapped);
    }

    public static Comparator groupFirst() {
        return new GroupFirst();
    }

    public static Comparator groupLast() {
        return Comparators.reverse(Comparators.groupFirst());
    }

    public static Comparator switchFirst() {
        return new SwitchFirst();
    }

    public static Comparator switchLast() {
        return Comparators.reverse(Comparators.switchFirst());
    }

    public static Comparator commandFirst() {
        return new CommandFirst();
    }

    public static Comparator commandLast() {
        return Comparators.reverse(Comparators.commandFirst());
    }

    public static Comparator defaultOptionFirst() {
        return new DefaultOptionFirst();
    }

    public static Comparator defaultOptionLast() {
        return Comparators.reverse(Comparators.defaultOptionFirst());
    }

    public static Comparator namedFirst(String name) {
        return new Named(name);
    }

    public static Comparator namedLast(String name) {
        return Comparators.reverse(new Named(name));
    }

    public static Comparator preferredNameFirst() {
        return new PreferredName();
    }

    public static Comparator preferredNameLast() {
        return Comparators.reverse(Comparators.preferredNameFirst());
    }

    public static Comparator requiredFirst() {
        return new Required();
    }

    public static Comparator requiredLast() {
        return Comparators.reverse(Comparators.requiredFirst());
    }

    private static class Chain
    implements Comparator {
        final Comparator[] chain;

        public Chain(Comparator[] chain) {
            this.chain = new Comparator[chain.length];
            System.arraycopy(chain, 0, this.chain, 0, chain.length);
        }

        public int compare(Object left, Object right) {
            int result = 0;
            int i = 0;
            while (result == 0 && i < this.chain.length) {
                result = this.chain[i].compare(left, right);
                ++i;
            }
            return result;
        }
    }

    private static class CommandFirst
    implements Comparator {
        private CommandFirst() {
        }

        public int compare(Object left, Object right) {
            boolean l = left instanceof Command;
            boolean r = right instanceof Command;
            if (l ^ r) {
                if (l) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class DefaultOptionFirst
    implements Comparator {
        private DefaultOptionFirst() {
        }

        public int compare(Object left, Object right) {
            boolean l = left instanceof DefaultOption;
            boolean r = right instanceof DefaultOption;
            if (l ^ r) {
                if (l) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class GroupFirst
    implements Comparator {
        private GroupFirst() {
        }

        public int compare(Object left, Object right) {
            boolean l = left instanceof Group;
            boolean r = right instanceof Group;
            if (l ^ r) {
                if (l) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class Named
    implements Comparator {
        private final String name;

        public Named(String name) {
            this.name = name;
        }

        public int compare(Object oleft, Object oright) {
            boolean r;
            Option left = (Option)oleft;
            Option right = (Option)oright;
            boolean l = left.getTriggers().contains(this.name);
            if (l ^ (r = right.getTriggers().contains(this.name))) {
                if (l) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class PreferredName
    implements Comparator {
        private PreferredName() {
        }

        public int compare(Object oleft, Object oright) {
            Option left = (Option)oleft;
            Option right = (Option)oright;
            return left.getPreferredName().compareTo(right.getPreferredName());
        }
    }

    private static class Required
    implements Comparator {
        private Required() {
        }

        public int compare(Object oleft, Object oright) {
            boolean r;
            Option left = (Option)oleft;
            Option right = (Option)oright;
            boolean l = left.isRequired();
            if (l ^ (r = right.isRequired())) {
                if (l) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private static class Reverse
    implements Comparator {
        private final Comparator wrapped;

        public Reverse(Comparator wrapped) {
            this.wrapped = wrapped;
        }

        public int compare(Object left, Object right) {
            return -this.wrapped.compare(left, right);
        }
    }

    private static class SwitchFirst
    implements Comparator {
        private SwitchFirst() {
        }

        public int compare(Object left, Object right) {
            boolean l = left instanceof Switch;
            boolean r = right instanceof Switch;
            if (l ^ r) {
                if (l) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

