/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.HelpLine;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.resource.ResourceHelper;

public class HelpFormatter {
    public static final int DEFAULT_FULL_WIDTH = 80;
    public static final String DEFAULT_GUTTER_LEFT = "";
    public static final String DEFAULT_GUTTER_CENTER = "    ";
    public static final String DEFAULT_GUTTER_RIGHT = "";
    public static final Set DEFAULT_FULL_USAGE_SETTINGS;
    public static final Set DEFAULT_LINE_USAGE_SETTINGS;
    public static final Set DEFAULT_DISPLAY_USAGE_SETTINGS;
    private Set fullUsageSettings = new HashSet(DEFAULT_FULL_USAGE_SETTINGS);
    private Set lineUsageSettings = new HashSet(DEFAULT_LINE_USAGE_SETTINGS);
    private Set displaySettings = new HashSet(DEFAULT_DISPLAY_USAGE_SETTINGS);
    private OptionException exception = null;
    private Group group;
    private Comparator comparator = null;
    private String divider = null;
    private String header = null;
    private String footer = null;
    private String shellCommand = "";
    private PrintWriter out = new PrintWriter(System.out);
    private final String gutterLeft;
    private final String gutterCenter;
    private final String gutterRight;
    private final int pageWidth;

    static {
        HashSet fullUsage = new HashSet(DisplaySetting.ALL);
        fullUsage.remove(DisplaySetting.DISPLAY_ALIASES);
        fullUsage.remove(DisplaySetting.DISPLAY_GROUP_NAME);
        DEFAULT_FULL_USAGE_SETTINGS = Collections.unmodifiableSet(fullUsage);
        HashSet<DisplaySetting> lineUsage = new HashSet<DisplaySetting>();
        lineUsage.add(DisplaySetting.DISPLAY_ALIASES);
        lineUsage.add(DisplaySetting.DISPLAY_GROUP_NAME);
        lineUsage.add(DisplaySetting.DISPLAY_PARENT_ARGUMENT);
        DEFAULT_LINE_USAGE_SETTINGS = Collections.unmodifiableSet(lineUsage);
        HashSet displayUsage = new HashSet(DisplaySetting.ALL);
        displayUsage.remove(DisplaySetting.DISPLAY_PARENT_ARGUMENT);
        DEFAULT_DISPLAY_USAGE_SETTINGS = Collections.unmodifiableSet(displayUsage);
    }

    public HelpFormatter() {
        this("", DEFAULT_GUTTER_CENTER, "", 80);
    }

    public HelpFormatter(String gutterLeft, String gutterCenter, String gutterRight, int fullWidth) {
        this.gutterLeft = gutterLeft == null ? "" : gutterLeft;
        this.gutterCenter = gutterCenter == null ? DEFAULT_GUTTER_CENTER : gutterCenter;
        this.gutterRight = gutterRight == null ? "" : gutterRight;
        this.pageWidth = fullWidth - this.gutterLeft.length() - this.gutterRight.length();
        int availableWidth = fullWidth - this.pageWidth + this.gutterCenter.length();
        if (availableWidth < 2) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("HelpFormatter.gutter.too.long"));
        }
    }

    public void print() {
        this.printHeader();
        this.printException();
        this.printUsage();
        this.printHelp();
        this.printFooter();
        this.out.flush();
    }

    public void printException() {
        if (this.exception != null) {
            this.printDivider();
            this.printWrapped(this.exception.getMessage());
        }
    }

    public void printHelp() {
        this.printDivider();
        Option option = this.exception != null && this.exception.getOption() != null ? this.exception.getOption() : this.group;
        List helpLines = option.helpLines(0, this.displaySettings, this.comparator);
        int usageWidth = 0;
        Iterator i = helpLines.iterator();
        while (i.hasNext()) {
            HelpLine helpLine = (HelpLine)i.next();
            String usage = helpLine.usage(this.lineUsageSettings, this.comparator);
            usageWidth = Math.max(usageWidth, usage.length());
        }
        StringBuffer blankBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < usageWidth) {
            blankBuffer.append(' ');
            ++i2;
        }
        int descriptionWidth = Math.max(1, this.pageWidth - this.gutterCenter.length() - usageWidth);
        Iterator i3 = helpLines.iterator();
        while (i3.hasNext()) {
            HelpLine helpLine = (HelpLine)i3.next();
            List descList = HelpFormatter.wrap(helpLine.getDescription(), descriptionWidth);
            Iterator descriptionIterator = descList.iterator();
            this.printGutterLeft();
            HelpFormatter.pad(helpLine.usage(this.lineUsageSettings, this.comparator), usageWidth, this.out);
            this.out.print(this.gutterCenter);
            HelpFormatter.pad((String)descriptionIterator.next(), descriptionWidth, this.out);
            this.printGutterRight();
            this.out.println();
            while (descriptionIterator.hasNext()) {
                this.printGutterLeft();
                this.out.print(blankBuffer);
                this.out.print(this.gutterCenter);
                HelpFormatter.pad((String)descriptionIterator.next(), descriptionWidth, this.out);
                this.printGutterRight();
                this.out.println();
            }
        }
        this.printDivider();
    }

    public void printUsage() {
        this.printDivider();
        StringBuffer buffer = new StringBuffer("Usage:\n");
        buffer.append(this.shellCommand).append(' ');
        this.group.appendUsage(buffer, this.fullUsageSettings, this.comparator, " ");
        this.printWrapped(buffer.toString());
    }

    public void printHeader() {
        if (this.header != null) {
            this.printDivider();
            this.printWrapped(this.header);
        }
    }

    public void printFooter() {
        if (this.footer != null) {
            this.printWrapped(this.footer);
            this.printDivider();
        }
    }

    public void printWrapped(String text) {
        Iterator i = HelpFormatter.wrap(text, this.pageWidth).iterator();
        while (i.hasNext()) {
            this.printGutterLeft();
            HelpFormatter.pad((String)i.next(), this.pageWidth, this.out);
            this.printGutterRight();
            this.out.println();
        }
        this.out.flush();
    }

    public void printGutterLeft() {
        if (this.gutterLeft != null) {
            this.out.print(this.gutterLeft);
        }
    }

    public void printGutterRight() {
        if (this.gutterRight != null) {
            this.out.print(this.gutterRight);
        }
    }

    public void printDivider() {
        if (this.divider != null) {
            this.out.println(this.divider);
        }
    }

    protected static void pad(String text, int width, PrintWriter writer) {
        int left;
        if (text == null) {
            left = 0;
        } else {
            writer.write(text);
            left = text.length();
        }
        int i = left;
        while (i < width) {
            writer.write(32);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static List wrap(String text, int width) {
        if (width < 1) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("HelpFormatter.width.too.narrow", new Object[]{new Integer(width)}));
        }
        if (text == null) {
            return Collections.singletonList("");
        }
        lines = new ArrayList<String>();
        chars = text.toCharArray();
        left = 0;
        while (left < chars.length) {
            right = left;
            while (right < chars.length && chars[right] != '\n' && right < left + width + 1) {
                ++right;
            }
            if (right < chars.length && chars[right] == '\n') {
                line = new String(chars, left, right - left);
                lines.add(line);
                left = right + 1;
                if (left != chars.length) continue;
                lines.add("");
                continue;
            }
            right = left + width - 1;
            if (chars.length > right) ** GOTO lbl29
            line = new String(chars, left, chars.length - left);
            lines.add(line);
            break;
lbl-1000:
            // 1 sources

            {
                --right;
lbl29:
                // 2 sources

                ** while (right >= left && chars[right] != ' ')
            }
lbl30:
            // 1 sources

            if (right >= left) {
                line = new String(chars, left, right - left);
                lines.add(line);
                while (right < chars.length && chars[right] == ' ') {
                    ++right;
                }
                left = right;
                continue;
            }
            right = Math.min(left + width, chars.length);
            line = new String(chars, left, right - left);
            lines.add(line);
            while (right < chars.length && chars[right] == ' ') {
                ++right;
            }
            left = right;
        }
        return lines;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setDisplaySettings(Set displaySettings) {
        this.displaySettings = displaySettings;
    }

    public void setDivider(String divider) {
        this.divider = divider;
    }

    public void setException(OptionException exception) {
        this.exception = exception;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setFullUsageSettings(Set fullUsageSettings) {
        this.fullUsageSettings = fullUsageSettings;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setLineUsageSettings(Set lineUsageSettings) {
        this.lineUsageSettings = lineUsageSettings;
    }

    public void setShellCommand(String shellCommand) {
        this.shellCommand = shellCommand;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Set getDisplaySettings() {
        return this.displaySettings;
    }

    public String getDivider() {
        return this.divider;
    }

    public OptionException getException() {
        return this.exception;
    }

    public String getFooter() {
        return this.footer;
    }

    public Set getFullUsageSettings() {
        return this.fullUsageSettings;
    }

    public Group getGroup() {
        return this.group;
    }

    public String getGutterCenter() {
        return this.gutterCenter;
    }

    public String getGutterLeft() {
        return this.gutterLeft;
    }

    public String getGutterRight() {
        return this.gutterRight;
    }

    public String getHeader() {
        return this.header;
    }

    public Set getLineUsageSettings() {
        return this.lineUsageSettings;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public String getShellCommand() {
        return this.shellCommand;
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getPrintWriter() {
        return this.out;
    }
}

